// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The status of data ingestion for this workspace.
/// </summary>
public enum OperationalInsightsDataIngestionStatus
{
    /// <summary>
    /// Ingestion enabled following daily cap quota reset, or subscription
    /// enablement.
    /// </summary>
    RespectQuota,

    /// <summary>
    /// Ingestion started following service setting change.
    /// </summary>
    ForceOn,

    /// <summary>
    /// Ingestion stopped following service setting change.
    /// </summary>
    ForceOff,

    /// <summary>
    /// Reached daily cap quota, ingestion stopped.
    /// </summary>
    OverQuota,

    /// <summary>
    /// Ingestion stopped following suspended subscription.
    /// </summary>
    SubscriptionSuspended,

    /// <summary>
    /// 80% of daily cap quota reached.
    /// </summary>
    ApproachingQuota,
}
