// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Column data type logical hint.
/// </summary>
public enum OperationalInsightsColumnDataTypeHint
{
    /// <summary>
    /// A string that matches the pattern of a URI, for example,
    /// scheme://username:password@host:1234/this/is/a/path?k1=v1&amp;k2=v2#fragment.
    /// </summary>
    [DataMember(Name = "uri")]
    Uri,

    /// <summary>
    /// A standard 128-bit GUID following the standard shape,
    /// xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx.
    /// </summary>
    [DataMember(Name = "guid")]
    Guid,

    /// <summary>
    /// An Azure Resource Model (ARM) path:
    /// /subscriptions/{...}/resourceGroups/{...}/providers/Microsoft.{...}/{...}/{...}/{...}...
    /// </summary>
    [DataMember(Name = "armPath")]
    ArmPath,

    /// <summary>
    /// A standard V4/V6 ip address following the standard shape,
    /// x.x.x.x/y:y:y:y:y:y:y:y.
    /// </summary>
    [DataMember(Name = "ip")]
    IP,
}
