// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Table column.
/// </summary>
public partial class OperationalInsightsColumn : ProvisionableConstruct
{
    /// <summary>
    /// Column name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Column data type.
    /// </summary>
    public BicepValue<OperationalInsightsColumnType> ColumnType 
    {
        get { Initialize(); return _columnType!; }
        set { Initialize(); _columnType!.Assign(value); }
    }
    private BicepValue<OperationalInsightsColumnType>? _columnType;

    /// <summary>
    /// Column data type logical hint.
    /// </summary>
    public BicepValue<OperationalInsightsColumnDataTypeHint> DataTypeHint 
    {
        get { Initialize(); return _dataTypeHint!; }
        set { Initialize(); _dataTypeHint!.Assign(value); }
    }
    private BicepValue<OperationalInsightsColumnDataTypeHint>? _dataTypeHint;

    /// <summary>
    /// Column display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Column description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Is displayed by default.
    /// </summary>
    public BicepValue<bool> IsDefaultDisplay 
    {
        get { Initialize(); return _isDefaultDisplay!; }
    }
    private BicepValue<bool>? _isDefaultDisplay;

    /// <summary>
    /// Is column hidden.
    /// </summary>
    public BicepValue<bool> IsHidden 
    {
        get { Initialize(); return _isHidden!; }
    }
    private BicepValue<bool>? _isHidden;

    /// <summary>
    /// Creates a new OperationalInsightsColumn.
    /// </summary>
    public OperationalInsightsColumn()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of OperationalInsightsColumn.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _columnType = DefineProperty<OperationalInsightsColumnType>("ColumnType", ["type"]);
        _dataTypeHint = DefineProperty<OperationalInsightsColumnDataTypeHint>("DataTypeHint", ["dataTypeHint"]);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _isDefaultDisplay = DefineProperty<bool>("IsDefaultDisplay", ["isDefaultDisplay"], isOutput: true);
        _isHidden = DefineProperty<bool>("IsHidden", ["isHidden"], isOutput: true);
    }
}
