// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The Capacity Reservation properties.
/// </summary>
public partial class OperationalInsightsCapacityReservationProperties : ProvisionableConstruct
{
    /// <summary>
    /// The last time Sku was updated.
    /// </summary>
    public BicepValue<DateTimeOffset> LastSkuUpdatedOn 
    {
        get { Initialize(); return _lastSkuUpdatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastSkuUpdatedOn;

    /// <summary>
    /// Minimum CapacityReservation value in GB.
    /// </summary>
    public BicepValue<long> MinCapacity 
    {
        get { Initialize(); return _minCapacity!; }
    }
    private BicepValue<long>? _minCapacity;

    /// <summary>
    /// Creates a new OperationalInsightsCapacityReservationProperties.
    /// </summary>
    public OperationalInsightsCapacityReservationProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsCapacityReservationProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _lastSkuUpdatedOn = DefineProperty<DateTimeOffset>("LastSkuUpdatedOn", ["lastSkuUpdate"], isOutput: true);
        _minCapacity = DefineProperty<long>("MinCapacity", ["minCapacity"], isOutput: true);
    }
}
