// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The related metadata items for the function.
/// </summary>
public partial class LogAnalyticsQueryRelatedMetadata : ProvisionableConstruct
{
    /// <summary>
    /// The related categories for the function.
    /// </summary>
    public BicepList<string> Categories 
    {
        get { Initialize(); return _categories!; }
        set { Initialize(); _categories!.Assign(value); }
    }
    private BicepList<string>? _categories;

    /// <summary>
    /// The related resource types for the function.
    /// </summary>
    public BicepList<string> ResourceTypes 
    {
        get { Initialize(); return _resourceTypes!; }
        set { Initialize(); _resourceTypes!.Assign(value); }
    }
    private BicepList<string>? _resourceTypes;

    /// <summary>
    /// The related Log Analytics solutions for the function.
    /// </summary>
    public BicepList<string> Solutions 
    {
        get { Initialize(); return _solutions!; }
        set { Initialize(); _solutions!.Assign(value); }
    }
    private BicepList<string>? _solutions;

    /// <summary>
    /// Creates a new LogAnalyticsQueryRelatedMetadata.
    /// </summary>
    public LogAnalyticsQueryRelatedMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// LogAnalyticsQueryRelatedMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _categories = DefineListProperty<string>("Categories", ["categories"]);
        _resourceTypes = DefineListProperty<string>("ResourceTypes", ["resourceTypes"]);
        _solutions = DefineListProperty<string>("Solutions", ["solutions"]);
    }
}
