// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// LogAnalyticsQueryPack.
/// </summary>
public partial class LogAnalyticsQueryPack : ProvisionableResource
{
    /// <summary>
    /// The name of the Log Analytics QueryPack resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
    /// </summary>
    public BicepValue<DateTimeOffset> ModifiedOn 
    {
        get { Initialize(); return _modifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _modifiedOn;

    /// <summary>
    /// Current state of this QueryPack: whether or not is has been provisioned
    /// within the resource group it is defined. Users cannot change this
    /// value but are able to read from it. Values will include Succeeded,
    /// Deploying, Canceled, and Failed.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// The unique ID of your application. This field cannot be changed.
    /// </summary>
    public BicepValue<Guid> QueryPackId 
    {
        get { Initialize(); return _queryPackId!; }
    }
    private BicepValue<Guid>? _queryPackId;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new LogAnalyticsQueryPack.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the LogAnalyticsQueryPack resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the LogAnalyticsQueryPack.</param>
    public LogAnalyticsQueryPack(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.OperationalInsights/queryPacks", resourceVersion ?? "2023-09-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LogAnalyticsQueryPack.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "timeCreated"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _modifiedOn = DefineProperty<DateTimeOffset>("ModifiedOn", ["properties", "timeModified"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _queryPackId = DefineProperty<Guid>("QueryPackId", ["properties", "queryPackId"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported LogAnalyticsQueryPack resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-09-01.
        /// </summary>
        public static readonly string V2023_09_01 = "2023-09-01";

        /// <summary>
        /// 2019-09-01.
        /// </summary>
        public static readonly string V2019_09_01 = "2019-09-01";
    }

    /// <summary>
    /// Creates a reference to an existing LogAnalyticsQueryPack.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the LogAnalyticsQueryPack resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the LogAnalyticsQueryPack.</param>
    /// <returns>The existing LogAnalyticsQueryPack resource.</returns>
    public static LogAnalyticsQueryPack FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
