// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// The Kustomization defining how to reconcile the artifact pulled by the
/// source type on the cluster.
/// </summary>
public partial class Kustomization : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Kustomization, matching the key in the Kustomizations
    /// object map.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The path in the source reference to reconcile on the cluster.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Specifies other Kustomizations that this Kustomization depends on. This
    /// Kustomization will not reconcile until all dependencies have completed
    /// their reconciliation.
    /// </summary>
    public BicepList<string> DependsOn 
    {
        get { Initialize(); return _dependsOn!; }
        set { Initialize(); _dependsOn!.Assign(value); }
    }
    private BicepList<string>? _dependsOn;

    /// <summary>
    /// The maximum time to attempt to reconcile the Kustomization on the
    /// cluster.
    /// </summary>
    public BicepValue<long> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _timeoutInSeconds;

    /// <summary>
    /// The interval at which to re-reconcile the Kustomization on the cluster.
    /// </summary>
    public BicepValue<long> SyncIntervalInSeconds 
    {
        get { Initialize(); return _syncIntervalInSeconds!; }
        set { Initialize(); _syncIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _syncIntervalInSeconds;

    /// <summary>
    /// The interval at which to re-reconcile the Kustomization on the cluster
    /// in the event of failure on reconciliation.
    /// </summary>
    public BicepValue<long> RetryIntervalInSeconds 
    {
        get { Initialize(); return _retryIntervalInSeconds!; }
        set { Initialize(); _retryIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _retryIntervalInSeconds;

    /// <summary>
    /// Enable/disable garbage collections of Kubernetes objects created by
    /// this Kustomization.
    /// </summary>
    public BicepValue<bool> Prune 
    {
        get { Initialize(); return _prune!; }
        set { Initialize(); _prune!.Assign(value); }
    }
    private BicepValue<bool>? _prune;

    /// <summary>
    /// Enable/disable re-creating Kubernetes resources on the cluster when
    /// patching fails due to an immutable field change.
    /// </summary>
    public BicepValue<bool> Force 
    {
        get { Initialize(); return _force!; }
        set { Initialize(); _force!.Assign(value); }
    }
    private BicepValue<bool>? _force;

    /// <summary>
    /// Creates a new Kustomization.
    /// </summary>
    public Kustomization()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of Kustomization.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _path = DefineProperty<string>("Path", ["path"]);
        _dependsOn = DefineListProperty<string>("DependsOn", ["dependsOn"]);
        _timeoutInSeconds = DefineProperty<long>("TimeoutInSeconds", ["timeoutInSeconds"]);
        _syncIntervalInSeconds = DefineProperty<long>("SyncIntervalInSeconds", ["syncIntervalInSeconds"]);
        _retryIntervalInSeconds = DefineProperty<long>("RetryIntervalInSeconds", ["retryIntervalInSeconds"]);
        _prune = DefineProperty<bool>("Prune", ["prune"]);
        _force = DefineProperty<bool>("Force", ["force"]);
    }
}
