// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Parameters to authenticate using Service Principal.
/// </summary>
public partial class KubernetesServicePrincipal : ProvisionableConstruct
{
    /// <summary>
    /// The client Id for authenticating a Service Principal.
    /// </summary>
    public BicepValue<Guid> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<Guid>? _clientId;

    /// <summary>
    /// The tenant Id for authenticating a Service Principal.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// The client secret for authenticating a Service Principal.
    /// </summary>
    public BicepValue<string> ClientSecret 
    {
        get { Initialize(); return _clientSecret!; }
        set { Initialize(); _clientSecret!.Assign(value); }
    }
    private BicepValue<string>? _clientSecret;

    /// <summary>
    /// Base64-encoded certificate used to authenticate a Service Principal.
    /// </summary>
    public BicepValue<string> ClientCertificate 
    {
        get { Initialize(); return _clientCertificate!; }
        set { Initialize(); _clientCertificate!.Assign(value); }
    }
    private BicepValue<string>? _clientCertificate;

    /// <summary>
    /// The password for the certificate used to authenticate a Service
    /// Principal.
    /// </summary>
    public BicepValue<string> ClientCertificatePassword 
    {
        get { Initialize(); return _clientCertificatePassword!; }
        set { Initialize(); _clientCertificatePassword!.Assign(value); }
    }
    private BicepValue<string>? _clientCertificatePassword;

    /// <summary>
    /// Specifies whether to include x5c header in client claims when acquiring
    /// a token to enable subject name / issuer based authentication for the
    /// Client Certificate.
    /// </summary>
    public BicepValue<bool> ClientCertificateSendChain 
    {
        get { Initialize(); return _clientCertificateSendChain!; }
        set { Initialize(); _clientCertificateSendChain!.Assign(value); }
    }
    private BicepValue<bool>? _clientCertificateSendChain;

    /// <summary>
    /// Creates a new KubernetesServicePrincipal.
    /// </summary>
    public KubernetesServicePrincipal()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesServicePrincipal.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientId = DefineProperty<Guid>("ClientId", ["clientId"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _clientSecret = DefineProperty<string>("ClientSecret", ["clientSecret"]);
        _clientCertificate = DefineProperty<string>("ClientCertificate", ["clientCertificate"]);
        _clientCertificatePassword = DefineProperty<string>("ClientCertificatePassword", ["clientCertificatePassword"]);
        _clientCertificateSendChain = DefineProperty<bool>("ClientCertificateSendChain", ["clientCertificateSendChain"]);
    }
}
