// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Statuses of objects deployed by the user-specified kustomizations from the
/// git repository.
/// </summary>
public partial class KubernetesObjectStatus : ProvisionableConstruct
{
    /// <summary>
    /// Name of the applied object.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Namespace of the applied object.
    /// </summary>
    public BicepValue<string> Namespace 
    {
        get { Initialize(); return _namespace!; }
    }
    private BicepValue<string>? _namespace;

    /// <summary>
    /// Kind of the applied object.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Compliance state of the applied object showing whether the applied
    /// object has come into a ready state on the cluster.
    /// </summary>
    public BicepValue<KubernetesFluxComplianceState> ComplianceState 
    {
        get { Initialize(); return _complianceState!; }
    }
    private BicepValue<KubernetesFluxComplianceState>? _complianceState;

    /// <summary>
    /// Object reference to the Kustomization that applied this object.
    /// </summary>
    public KubernetesObjectReference AppliedBy 
    {
        get { Initialize(); return _appliedBy!; }
    }
    private KubernetesObjectReference? _appliedBy;

    /// <summary>
    /// List of Kubernetes object status conditions present on the cluster.
    /// </summary>
    public BicepList<KubernetesObjectStatusCondition> StatusConditions 
    {
        get { Initialize(); return _statusConditions!; }
    }
    private BicepList<KubernetesObjectStatusCondition>? _statusConditions;

    /// <summary>
    /// Additional properties that are provided from objects of the HelmRelease
    /// kind.
    /// </summary>
    public HelmReleaseProperties HelmReleaseProperties 
    {
        get { Initialize(); return _helmReleaseProperties!; }
    }
    private HelmReleaseProperties? _helmReleaseProperties;

    /// <summary>
    /// Creates a new KubernetesObjectStatus.
    /// </summary>
    public KubernetesObjectStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesObjectStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _namespace = DefineProperty<string>("Namespace", ["namespace"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _complianceState = DefineProperty<KubernetesFluxComplianceState>("ComplianceState", ["complianceState"], isOutput: true);
        _appliedBy = DefineModelProperty<KubernetesObjectReference>("AppliedBy", ["appliedBy"], isOutput: true);
        _statusConditions = DefineListProperty<KubernetesObjectStatusCondition>("StatusConditions", ["statusConditions"], isOutput: true);
        _helmReleaseProperties = DefineModelProperty<HelmReleaseProperties>("HelmReleaseProperties", ["helmReleaseProperties"], isOutput: true);
    }
}
