// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// The source reference for the GitRepository object.
/// </summary>
public partial class KubernetesGitRepositoryRef : ProvisionableConstruct
{
    /// <summary>
    /// The git repository branch name to checkout.
    /// </summary>
    public BicepValue<string> Branch 
    {
        get { Initialize(); return _branch!; }
        set { Initialize(); _branch!.Assign(value); }
    }
    private BicepValue<string>? _branch;

    /// <summary>
    /// The git repository tag name to checkout. This takes precedence over
    /// branch.
    /// </summary>
    public BicepValue<string> Tag 
    {
        get { Initialize(); return _tag!; }
        set { Initialize(); _tag!.Assign(value); }
    }
    private BicepValue<string>? _tag;

    /// <summary>
    /// The semver range used to match against git repository tags. This takes
    /// precedence over tag.
    /// </summary>
    public BicepValue<string> Semver 
    {
        get { Initialize(); return _semver!; }
        set { Initialize(); _semver!.Assign(value); }
    }
    private BicepValue<string>? _semver;

    /// <summary>
    /// The commit SHA to checkout. This value must be combined with the branch
    /// name to be valid. This takes precedence over semver.
    /// </summary>
    public BicepValue<string> Commit 
    {
        get { Initialize(); return _commit!; }
        set { Initialize(); _commit!.Assign(value); }
    }
    private BicepValue<string>? _commit;

    /// <summary>
    /// Creates a new KubernetesGitRepositoryRef.
    /// </summary>
    public KubernetesGitRepositoryRef()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesGitRepositoryRef.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _branch = DefineProperty<string>("Branch", ["branch"]);
        _tag = DefineProperty<string>("Tag", ["tag"]);
        _semver = DefineProperty<string>("Semver", ["semver"]);
        _commit = DefineProperty<string>("Commit", ["commit"]);
    }
}
