// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Parameters to reconcile to the GitRepository source kind type.
/// </summary>
public partial class KubernetesGitRepository : ProvisionableConstruct
{
    /// <summary>
    /// The URL to sync for the flux configuration git repository.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// The maximum time to attempt to reconcile the cluster git repository
    /// source with the remote.
    /// </summary>
    public BicepValue<long> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _timeoutInSeconds;

    /// <summary>
    /// The interval at which to re-reconcile the cluster git repository source
    /// with the remote.
    /// </summary>
    public BicepValue<long> SyncIntervalInSeconds 
    {
        get { Initialize(); return _syncIntervalInSeconds!; }
        set { Initialize(); _syncIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _syncIntervalInSeconds;

    /// <summary>
    /// The source reference for the GitRepository object.
    /// </summary>
    public KubernetesGitRepositoryRef RepositoryRef 
    {
        get { Initialize(); return _repositoryRef!; }
        set { Initialize(); AssignOrReplace(ref _repositoryRef, value); }
    }
    private KubernetesGitRepositoryRef? _repositoryRef;

    /// <summary>
    /// Base64-encoded known_hosts value containing public SSH keys required to
    /// access private git repositories over SSH.
    /// </summary>
    public BicepValue<string> SshKnownHosts 
    {
        get { Initialize(); return _sshKnownHosts!; }
        set { Initialize(); _sshKnownHosts!.Assign(value); }
    }
    private BicepValue<string>? _sshKnownHosts;

    /// <summary>
    /// Plaintext HTTPS username used to access private git repositories over
    /// HTTPS.
    /// </summary>
    public BicepValue<string> HttpsUser 
    {
        get { Initialize(); return _httpsUser!; }
        set { Initialize(); _httpsUser!.Assign(value); }
    }
    private BicepValue<string>? _httpsUser;

    /// <summary>
    /// Base64-encoded HTTPS certificate authority contents used to access git
    /// private git repositories over HTTPS.
    /// </summary>
    public BicepValue<string> HttpsCACert 
    {
        get { Initialize(); return _httpsCACert!; }
        set { Initialize(); _httpsCACert!.Assign(value); }
    }
    private BicepValue<string>? _httpsCACert;

    /// <summary>
    /// Name of a local secret on the Kubernetes cluster to use as the
    /// authentication secret rather than the managed or user-provided
    /// configuration secrets.
    /// </summary>
    public BicepValue<string> LocalAuthRef 
    {
        get { Initialize(); return _localAuthRef!; }
        set { Initialize(); _localAuthRef!.Assign(value); }
    }
    private BicepValue<string>? _localAuthRef;

    /// <summary>
    /// Creates a new KubernetesGitRepository.
    /// </summary>
    public KubernetesGitRepository()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesGitRepository.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _uri = DefineProperty<Uri>("Uri", ["url"]);
        _timeoutInSeconds = DefineProperty<long>("TimeoutInSeconds", ["timeoutInSeconds"]);
        _syncIntervalInSeconds = DefineProperty<long>("SyncIntervalInSeconds", ["syncIntervalInSeconds"]);
        _repositoryRef = DefineModelProperty<KubernetesGitRepositoryRef>("RepositoryRef", ["repositoryRef"]);
        _sshKnownHosts = DefineProperty<string>("SshKnownHosts", ["sshKnownHosts"]);
        _httpsUser = DefineProperty<string>("HttpsUser", ["httpsUser"]);
        _httpsCACert = DefineProperty<string>("HttpsCACert", ["httpsCACert"]);
        _localAuthRef = DefineProperty<string>("LocalAuthRef", ["localAuthRef"]);
    }
}
