// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Compliance Status details.
/// </summary>
public partial class KubernetesConfigurationComplianceStatus : ProvisionableConstruct
{
    /// <summary>
    /// The compliance state of the configuration.
    /// </summary>
    public BicepValue<KubernetesConfigurationComplianceStateType> ComplianceState 
    {
        get { Initialize(); return _complianceState!; }
    }
    private BicepValue<KubernetesConfigurationComplianceStateType>? _complianceState;

    /// <summary>
    /// Datetime the configuration was last applied.
    /// </summary>
    public BicepValue<DateTimeOffset> LastConfigAppliedOn 
    {
        get { Initialize(); return _lastConfigAppliedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastConfigAppliedOn;

    /// <summary>
    /// Message from when the configuration was applied.
    /// </summary>
    public BicepValue<string> Message 
    {
        get { Initialize(); return _message!; }
    }
    private BicepValue<string>? _message;

    /// <summary>
    /// Level of the message.
    /// </summary>
    public BicepValue<KubernetesConfigurationMesageLevel> MessageLevel 
    {
        get { Initialize(); return _messageLevel!; }
    }
    private BicepValue<KubernetesConfigurationMesageLevel>? _messageLevel;

    /// <summary>
    /// Creates a new KubernetesConfigurationComplianceStatus.
    /// </summary>
    public KubernetesConfigurationComplianceStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// KubernetesConfigurationComplianceStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _complianceState = DefineProperty<KubernetesConfigurationComplianceStateType>("ComplianceState", ["complianceState"], isOutput: true);
        _lastConfigAppliedOn = DefineProperty<DateTimeOffset>("LastConfigAppliedOn", ["lastConfigApplied"], isOutput: true);
        _message = DefineProperty<string>("Message", ["message"], isOutput: true);
        _messageLevel = DefineProperty<KubernetesConfigurationMesageLevel>("MessageLevel", ["messageLevel"], isOutput: true);
    }
}
