// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Scope of the extension. It can be either Cluster or Namespace; but not both.
/// </summary>
public partial class KubernetesClusterExtensionScope : ProvisionableConstruct
{
    /// <summary>
    /// Namespace where the extension Release must be placed, for a Cluster
    /// scoped extension.  If this namespace does not exist, it will be
    /// created.
    /// </summary>
    public BicepValue<string> ClusterReleaseNamespace 
    {
        get { Initialize(); return _clusterReleaseNamespace!; }
        set { Initialize(); _clusterReleaseNamespace!.Assign(value); }
    }
    private BicepValue<string>? _clusterReleaseNamespace;

    /// <summary>
    /// Namespace where the extension will be created for an Namespace scoped
    /// extension.  If this namespace does not exist, it will be created.
    /// </summary>
    public BicepValue<string> TargetNamespace 
    {
        get { Initialize(); return _targetNamespace!; }
        set { Initialize(); _targetNamespace!.Assign(value); }
    }
    private BicepValue<string>? _targetNamespace;

    /// <summary>
    /// Creates a new KubernetesClusterExtensionScope.
    /// </summary>
    public KubernetesClusterExtensionScope()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// KubernetesClusterExtensionScope.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clusterReleaseNamespace = DefineProperty<string>("ClusterReleaseNamespace", ["cluster", "releaseNamespace"]);
        _targetNamespace = DefineProperty<string>("TargetNamespace", ["namespace", "targetNamespace"]);
    }
}
