// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Parameters to reconcile to the Bucket source kind type.
/// </summary>
public partial class KubernetesBucket : ProvisionableConstruct
{
    /// <summary>
    /// The URL to sync for the flux configuration S3 bucket.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// The bucket name to sync from the url endpoint for the flux
    /// configuration.
    /// </summary>
    public BicepValue<string> BucketName 
    {
        get { Initialize(); return _bucketName!; }
        set { Initialize(); _bucketName!.Assign(value); }
    }
    private BicepValue<string>? _bucketName;

    /// <summary>
    /// Specify whether to use insecure communication when puling data from the
    /// S3 bucket.
    /// </summary>
    public BicepValue<bool> UseInsecureCommunication 
    {
        get { Initialize(); return _useInsecureCommunication!; }
        set { Initialize(); _useInsecureCommunication!.Assign(value); }
    }
    private BicepValue<bool>? _useInsecureCommunication;

    /// <summary>
    /// The maximum time to attempt to reconcile the cluster bucket source with
    /// the remote.
    /// </summary>
    public BicepValue<long> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _timeoutInSeconds;

    /// <summary>
    /// The interval at which to re-reconcile the cluster bucket source with
    /// the remote.
    /// </summary>
    public BicepValue<long> SyncIntervalInSeconds 
    {
        get { Initialize(); return _syncIntervalInSeconds!; }
        set { Initialize(); _syncIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _syncIntervalInSeconds;

    /// <summary>
    /// Plaintext access key used to securely access the S3 bucket.
    /// </summary>
    public BicepValue<string> AccessKey 
    {
        get { Initialize(); return _accessKey!; }
        set { Initialize(); _accessKey!.Assign(value); }
    }
    private BicepValue<string>? _accessKey;

    /// <summary>
    /// Name of a local secret on the Kubernetes cluster to use as the
    /// authentication secret rather than the managed or user-provided
    /// configuration secrets.
    /// </summary>
    public BicepValue<string> LocalAuthRef 
    {
        get { Initialize(); return _localAuthRef!; }
        set { Initialize(); _localAuthRef!.Assign(value); }
    }
    private BicepValue<string>? _localAuthRef;

    /// <summary>
    /// Creates a new KubernetesBucket.
    /// </summary>
    public KubernetesBucket()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesBucket.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _uri = DefineProperty<Uri>("Uri", ["url"]);
        _bucketName = DefineProperty<string>("BucketName", ["bucketName"]);
        _useInsecureCommunication = DefineProperty<bool>("UseInsecureCommunication", ["insecure"]);
        _timeoutInSeconds = DefineProperty<long>("TimeoutInSeconds", ["timeoutInSeconds"]);
        _syncIntervalInSeconds = DefineProperty<long>("SyncIntervalInSeconds", ["syncIntervalInSeconds"]);
        _accessKey = DefineProperty<string>("AccessKey", ["accessKey"]);
        _localAuthRef = DefineProperty<string>("LocalAuthRef", ["localAuthRef"]);
    }
}
