// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Parameters to reconcile to the AzureBlob source kind type.
/// </summary>
public partial class KubernetesAzureBlob : ProvisionableConstruct
{
    /// <summary>
    /// The URL to sync for the flux configuration Azure Blob storage account.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// The Azure Blob container name to sync from the url endpoint for the
    /// flux configuration.
    /// </summary>
    public BicepValue<string> ContainerName 
    {
        get { Initialize(); return _containerName!; }
        set { Initialize(); _containerName!.Assign(value); }
    }
    private BicepValue<string>? _containerName;

    /// <summary>
    /// The maximum time to attempt to reconcile the cluster Azure Blob source
    /// with the remote.
    /// </summary>
    public BicepValue<long> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _timeoutInSeconds;

    /// <summary>
    /// The interval at which to re-reconcile the cluster Azure Blob source
    /// with the remote.
    /// </summary>
    public BicepValue<long> SyncIntervalInSeconds 
    {
        get { Initialize(); return _syncIntervalInSeconds!; }
        set { Initialize(); _syncIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<long>? _syncIntervalInSeconds;

    /// <summary>
    /// Parameters to authenticate using Service Principal.
    /// </summary>
    public KubernetesServicePrincipal ServicePrincipal 
    {
        get { Initialize(); return _servicePrincipal!; }
        set { Initialize(); AssignOrReplace(ref _servicePrincipal, value); }
    }
    private KubernetesServicePrincipal? _servicePrincipal;

    /// <summary>
    /// The account key (shared key) to access the storage account.
    /// </summary>
    public BicepValue<string> AccountKey 
    {
        get { Initialize(); return _accountKey!; }
        set { Initialize(); _accountKey!.Assign(value); }
    }
    private BicepValue<string>? _accountKey;

    /// <summary>
    /// The Shared Access token to access the storage container.
    /// </summary>
    public BicepValue<string> SasToken 
    {
        get { Initialize(); return _sasToken!; }
        set { Initialize(); _sasToken!.Assign(value); }
    }
    private BicepValue<string>? _sasToken;

    /// <summary>
    /// The client Id for authenticating a Managed Identity.
    /// </summary>
    public BicepValue<Guid> ManagedIdentityClientId 
    {
        get { Initialize(); return _managedIdentityClientId!; }
        set { Initialize(); _managedIdentityClientId!.Assign(value); }
    }
    private BicepValue<Guid>? _managedIdentityClientId;

    /// <summary>
    /// Name of a local secret on the Kubernetes cluster to use as the
    /// authentication secret rather than the managed or user-provided
    /// configuration secrets.
    /// </summary>
    public BicepValue<string> LocalAuthRef 
    {
        get { Initialize(); return _localAuthRef!; }
        set { Initialize(); _localAuthRef!.Assign(value); }
    }
    private BicepValue<string>? _localAuthRef;

    /// <summary>
    /// Creates a new KubernetesAzureBlob.
    /// </summary>
    public KubernetesAzureBlob()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesAzureBlob.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _uri = DefineProperty<Uri>("Uri", ["url"]);
        _containerName = DefineProperty<string>("ContainerName", ["containerName"]);
        _timeoutInSeconds = DefineProperty<long>("TimeoutInSeconds", ["timeoutInSeconds"]);
        _syncIntervalInSeconds = DefineProperty<long>("SyncIntervalInSeconds", ["syncIntervalInSeconds"]);
        _servicePrincipal = DefineModelProperty<KubernetesServicePrincipal>("ServicePrincipal", ["servicePrincipal"]);
        _accountKey = DefineProperty<string>("AccountKey", ["accountKey"]);
        _sasToken = DefineProperty<string>("SasToken", ["sasToken"]);
        _managedIdentityClientId = DefineProperty<Guid>("ManagedIdentityClientId", ["managedIdentity", "clientId"]);
        _localAuthRef = DefineProperty<string>("LocalAuthRef", ["localAuthRef"]);
    }
}
