// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Properties for HelmRelease objects.
/// </summary>
public partial class HelmReleaseProperties : ProvisionableConstruct
{
    /// <summary>
    /// The revision number of the last released object change.
    /// </summary>
    public BicepValue<long> LastRevisionApplied 
    {
        get { Initialize(); return _lastRevisionApplied!; }
    }
    private BicepValue<long>? _lastRevisionApplied;

    /// <summary>
    /// The reference to the HelmChart object used as the source to this
    /// HelmRelease.
    /// </summary>
    public KubernetesObjectReference HelmChartRef 
    {
        get { Initialize(); return _helmChartRef!; }
    }
    private KubernetesObjectReference? _helmChartRef;

    /// <summary>
    /// Total number of times that the HelmRelease failed to install or upgrade.
    /// </summary>
    public BicepValue<long> FailureCount 
    {
        get { Initialize(); return _failureCount!; }
    }
    private BicepValue<long>? _failureCount;

    /// <summary>
    /// Number of times that the HelmRelease failed to install.
    /// </summary>
    public BicepValue<long> InstallFailureCount 
    {
        get { Initialize(); return _installFailureCount!; }
    }
    private BicepValue<long>? _installFailureCount;

    /// <summary>
    /// Number of times that the HelmRelease failed to upgrade.
    /// </summary>
    public BicepValue<long> UpgradeFailureCount 
    {
        get { Initialize(); return _upgradeFailureCount!; }
    }
    private BicepValue<long>? _upgradeFailureCount;

    /// <summary>
    /// Creates a new HelmReleaseProperties.
    /// </summary>
    public HelmReleaseProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of HelmReleaseProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _lastRevisionApplied = DefineProperty<long>("LastRevisionApplied", ["lastRevisionApplied"], isOutput: true);
        _helmChartRef = DefineModelProperty<KubernetesObjectReference>("HelmChartRef", ["helmChartRef"], isOutput: true);
        _failureCount = DefineProperty<long>("FailureCount", ["failureCount"], isOutput: true);
        _installFailureCount = DefineProperty<long>("InstallFailureCount", ["installFailureCount"], isOutput: true);
        _upgradeFailureCount = DefineProperty<long>("UpgradeFailureCount", ["upgradeFailureCount"], isOutput: true);
    }
}
