// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// Built-in KubernetesConfiguration roles that you can assign to users,
/// groups, service principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct KubernetesConfigurationBuiltInRole(string value) : IEquatable<KubernetesConfigurationBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Install Azure Container Storage and manage its storage resources.
    /// Includes an ABAC condition to constrain role assignments.
    /// </summary>
    public static KubernetesConfigurationBuiltInRole AzureContainerStorageContributor { get; } = new(AzureContainerStorageContributorValue);
    internal const string AzureContainerStorageContributorValue = "95dd08a6-00bd-4661-84bf-f6726f83a4d0";

    /// <summary>
    /// Enable a managed identity to perform Azure Container Storage
    /// operations, such as manage virtual machines and manage virtual
    /// networks.
    /// </summary>
    public static KubernetesConfigurationBuiltInRole AzureContainerStorageOperator { get; } = new(AzureContainerStorageOperatorValue);
    internal const string AzureContainerStorageOperatorValue = "08d4c71a-cc63-4ce4-a9c8-5dd251b4d619";

    /// <summary>
    /// Install Azure Container Storage, grant access to its storage resources,
    /// and configure Azure Elastic storage area network (SAN). Includes an
    /// ABAC condition to constrain role assignments.
    /// </summary>
    public static KubernetesConfigurationBuiltInRole AzureContainerStorageOwner { get; } = new(AzureContainerStorageOwnerValue);
    internal const string AzureContainerStorageOwnerValue = "95de85bd-744d-4664-9dde-11430bc34793";

    /// <summary>
    /// Can create, update, get, list and delete Kubernetes Extensions, and get
    /// extension async operations
    /// </summary>
    public static KubernetesConfigurationBuiltInRole KubernetesExtensionContributor { get; } = new(KubernetesExtensionContributorValue);
    internal const string KubernetesExtensionContributorValue = "85cb6faf-e071-4c9b-8136-154b5a04f717";

    /// <summary>
    /// Try to get the name of a built-in KubernetesConfiguration role from its
    /// ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in KubernetesConfiguration role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(KubernetesConfigurationBuiltInRole value) =>
        value._value switch
        {
            AzureContainerStorageContributorValue => nameof(AzureContainerStorageContributor),
            AzureContainerStorageOperatorValue => nameof(AzureContainerStorageOperator),
            AzureContainerStorageOwnerValue => nameof(AzureContainerStorageOwner),
            KubernetesExtensionContributorValue => nameof(KubernetesExtensionContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two KubernetesConfigurationBuiltInRole values are the
    /// same.
    /// </summary>
    /// <param name="left">The first KubernetesConfigurationBuiltInRole to compare.</param>
    /// <param name="right">The second KubernetesConfigurationBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(KubernetesConfigurationBuiltInRole left, KubernetesConfigurationBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two KubernetesConfigurationBuiltInRole values are
    /// different.
    /// </summary>
    /// <param name="left">The first KubernetesConfigurationBuiltInRole to compare.</param>
    /// <param name="right">The second KubernetesConfigurationBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(KubernetesConfigurationBuiltInRole left, KubernetesConfigurationBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a KubernetesConfigurationBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator KubernetesConfigurationBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is KubernetesConfigurationBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(KubernetesConfigurationBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
