// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;

namespace Azure.Provisioning.KubernetesConfiguration;

/// <summary>
/// KubernetesClusterExtension.
/// </summary>
public partial class KubernetesClusterExtension : ProvisionableResource
{
    /// <summary>
    /// Name of the Extension.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Identity of the Extension resource in an AKS cluster. Current supported
    /// identity types: SystemAssigned, UserAssigned.
    /// </summary>
    public ManagedServiceIdentity AksAssignedIdentity 
    {
        get { Initialize(); return _aksAssignedIdentity!; }
        set { Initialize(); AssignOrReplace(ref _aksAssignedIdentity, value); }
    }
    private ManagedServiceIdentity? _aksAssignedIdentity;

    /// <summary>
    /// Flag to note if this extension participates in auto upgrade of minor
    /// version, or not.
    /// </summary>
    public BicepValue<bool> AutoUpgradeMinorVersion 
    {
        get { Initialize(); return _autoUpgradeMinorVersion!; }
        set { Initialize(); _autoUpgradeMinorVersion!.Assign(value); }
    }
    private BicepValue<bool>? _autoUpgradeMinorVersion;

    /// <summary>
    /// Configuration settings that are sensitive, as name-value pairs for
    /// configuring this extension.
    /// </summary>
    public BicepDictionary<string> ConfigurationProtectedSettings 
    {
        get { Initialize(); return _configurationProtectedSettings!; }
        set { Initialize(); _configurationProtectedSettings!.Assign(value); }
    }
    private BicepDictionary<string>? _configurationProtectedSettings;

    /// <summary>
    /// Configuration settings, as name-value pairs for configuring this
    /// extension.
    /// </summary>
    public BicepDictionary<string> ConfigurationSettings 
    {
        get { Initialize(); return _configurationSettings!; }
        set { Initialize(); _configurationSettings!.Assign(value); }
    }
    private BicepDictionary<string>? _configurationSettings;

    /// <summary>
    /// Type of the Extension, of which this resource is an instance of.  It
    /// must be one of the Extension Types registered with
    /// Microsoft.KubernetesConfiguration by the Extension publisher.
    /// </summary>
    public BicepValue<string> ExtensionType 
    {
        get { Initialize(); return _extensionType!; }
        set { Initialize(); _extensionType!.Assign(value); }
    }
    private BicepValue<string>? _extensionType;

    /// <summary>
    /// Identity of the Extension resource. Current supported identity types:
    /// SystemAssigned.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The plan information.
    /// </summary>
    public ArmPlan Plan 
    {
        get { Initialize(); return _plan!; }
        set { Initialize(); AssignOrReplace(ref _plan, value); }
    }
    private ArmPlan? _plan;

    /// <summary>
    /// ReleaseTrain this extension participates in for auto-upgrade (e.g.
    /// Stable, Preview, etc.) - only if autoUpgradeMinorVersion is
    /// &apos;true&apos;.
    /// </summary>
    public BicepValue<string> ReleaseTrain 
    {
        get { Initialize(); return _releaseTrain!; }
        set { Initialize(); _releaseTrain!.Assign(value); }
    }
    private BicepValue<string>? _releaseTrain;

    /// <summary>
    /// Scope at which the extension is installed.
    /// </summary>
    public KubernetesClusterExtensionScope Scope 
    {
        get { Initialize(); return _scope!; }
        set { Initialize(); AssignOrReplace(ref _scope, value); }
    }
    private KubernetesClusterExtensionScope? _scope;

    /// <summary>
    /// Status from this extension.
    /// </summary>
    public BicepList<KubernetesClusterExtensionStatus> Statuses 
    {
        get { Initialize(); return _statuses!; }
        set { Initialize(); _statuses!.Assign(value); }
    }
    private BicepList<KubernetesClusterExtensionStatus>? _statuses;

    /// <summary>
    /// User-specified version of the extension for this extension to
    /// &apos;pin&apos;. To use &apos;version&apos;, autoUpgradeMinorVersion
    /// must be &apos;false&apos;.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Currently installed version of the extension.
    /// </summary>
    public BicepValue<string> CurrentVersion 
    {
        get { Initialize(); return _currentVersion!; }
    }
    private BicepValue<string>? _currentVersion;

    /// <summary>
    /// Custom Location settings properties.
    /// </summary>
    public BicepDictionary<string> CustomLocationSettings 
    {
        get { Initialize(); return _customLocationSettings!; }
    }
    private BicepDictionary<string>? _customLocationSettings;

    /// <summary>
    /// Error information from the Agent - e.g. errors during installation.
    /// </summary>
    public BicepValue<ResponseError> ErrorInfo 
    {
        get { Initialize(); return _errorInfo!; }
    }
    private BicepValue<ResponseError>? _errorInfo;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Flag to note if this extension is a system extension.
    /// </summary>
    public BicepValue<bool> IsSystemExtension 
    {
        get { Initialize(); return _isSystemExtension!; }
    }
    private BicepValue<bool>? _isSystemExtension;

    /// <summary>
    /// Uri of the Helm package.
    /// </summary>
    public BicepValue<Uri> PackageUri 
    {
        get { Initialize(); return _packageUri!; }
    }
    private BicepValue<Uri>? _packageUri;

    /// <summary>
    /// Status of installation of this extension.
    /// </summary>
    public BicepValue<KubernetesConfigurationProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<KubernetesConfigurationProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new KubernetesClusterExtension.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the KubernetesClusterExtension
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the KubernetesClusterExtension.</param>
    public KubernetesClusterExtension(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.KubernetesConfiguration/extensions", resourceVersion ?? "2023-05-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubernetesClusterExtension.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _aksAssignedIdentity = DefineModelProperty<ManagedServiceIdentity>("AksAssignedIdentity", ["properties", "aksAssignedIdentity"]);
        _autoUpgradeMinorVersion = DefineProperty<bool>("AutoUpgradeMinorVersion", ["properties", "autoUpgradeMinorVersion"]);
        _configurationProtectedSettings = DefineDictionaryProperty<string>("ConfigurationProtectedSettings", ["properties", "configurationProtectedSettings"]);
        _configurationSettings = DefineDictionaryProperty<string>("ConfigurationSettings", ["properties", "configurationSettings"]);
        _extensionType = DefineProperty<string>("ExtensionType", ["properties", "extensionType"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _plan = DefineModelProperty<ArmPlan>("Plan", ["plan"]);
        _releaseTrain = DefineProperty<string>("ReleaseTrain", ["properties", "releaseTrain"]);
        _scope = DefineModelProperty<KubernetesClusterExtensionScope>("Scope", ["properties", "scope"]);
        _statuses = DefineListProperty<KubernetesClusterExtensionStatus>("Statuses", ["properties", "statuses"]);
        _version = DefineProperty<string>("Version", ["properties", "version"]);
        _currentVersion = DefineProperty<string>("CurrentVersion", ["properties", "currentVersion"], isOutput: true);
        _customLocationSettings = DefineDictionaryProperty<string>("CustomLocationSettings", ["properties", "customLocationSettings"], isOutput: true);
        _errorInfo = DefineProperty<ResponseError>("ErrorInfo", ["properties", "errorInfo"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isSystemExtension = DefineProperty<bool>("IsSystemExtension", ["properties", "isSystemExtension"], isOutput: true);
        _packageUri = DefineProperty<Uri>("PackageUri", ["properties", "packageUri"], isOutput: true);
        _provisioningState = DefineProperty<KubernetesConfigurationProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported KubernetesClusterExtension resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2022-11-01.
        /// </summary>
        public static readonly string V2022_11_01 = "2022-11-01";

        /// <summary>
        /// 2022-07-01.
        /// </summary>
        public static readonly string V2022_07_01 = "2022-07-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing KubernetesClusterExtension.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the KubernetesClusterExtension
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the KubernetesClusterExtension.</param>
    /// <returns>The existing KubernetesClusterExtension resource.</returns>
    public static KubernetesClusterExtension FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this KubernetesClusterExtension.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(KubernetesConfigurationBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{KubernetesConfigurationBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// KubernetesClusterExtension.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(KubernetesConfigurationBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{KubernetesConfigurationBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
