// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.Kubernetes;

/// <summary>
/// Built-in Kubernetes roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct KubernetesBuiltInRole(string value) : IEquatable<KubernetesBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Role definition to authorize any user/service to create
    /// connectedClusters resource
    /// </summary>
    public static KubernetesBuiltInRole KubernetesClusterAzureArcOnboarding { get; } = new(KubernetesClusterAzureArcOnboardingValue);
    internal const string KubernetesClusterAzureArcOnboardingValue = "34e09817-6cbe-4d01-b1a2-e0eac5743d41";

    /// <summary>
    /// Try to get the name of a built-in Kubernetes role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in Kubernetes role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(KubernetesBuiltInRole value) =>
        value._value switch
        {
            KubernetesClusterAzureArcOnboardingValue => nameof(KubernetesClusterAzureArcOnboarding),
            _ => value._value
        };

    /// <summary>
    /// Determines if two KubernetesBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first KubernetesBuiltInRole to compare.</param>
    /// <param name="right">The second KubernetesBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(KubernetesBuiltInRole left, KubernetesBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two KubernetesBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first KubernetesBuiltInRole to compare.</param>
    /// <param name="right">The second KubernetesBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(KubernetesBuiltInRole left, KubernetesBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a KubernetesBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator KubernetesBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is KubernetesBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(KubernetesBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
