// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Kubernetes;

/// <summary>
/// ConnectedCluster.
/// </summary>
public partial class ConnectedCluster : ProvisionableResource
{
    /// <summary>
    /// The name of the Kubernetes cluster on which get is called.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Base64 encoded public certificate used by the agent to do the initial
    /// handshake to the backend services in Azure.
    /// </summary>
    public BicepValue<string> AgentPublicKeyCertificate 
    {
        get { Initialize(); return _agentPublicKeyCertificate!; }
        set { Initialize(); _agentPublicKeyCertificate!.Assign(value); }
    }
    private BicepValue<string>? _agentPublicKeyCertificate;

    /// <summary>
    /// The identity of the connected cluster. Current supported identity
    /// types: None, SystemAssigned.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The Kubernetes distribution running on this connected cluster.
    /// </summary>
    public BicepValue<string> Distribution 
    {
        get { Initialize(); return _distribution!; }
        set { Initialize(); _distribution!.Assign(value); }
    }
    private BicepValue<string>? _distribution;

    /// <summary>
    /// The infrastructure on which the Kubernetes cluster represented by this
    /// connected cluster is running on.
    /// </summary>
    public BicepValue<string> Infrastructure 
    {
        get { Initialize(); return _infrastructure!; }
        set { Initialize(); _infrastructure!.Assign(value); }
    }
    private BicepValue<string>? _infrastructure;

    /// <summary>
    /// The resource id of the private link scope this connected cluster is
    /// assigned to, if any.
    /// </summary>
    public BicepValue<string> PrivateLinkScopeResourceId 
    {
        get { Initialize(); return _privateLinkScopeResourceId!; }
        set { Initialize(); _privateLinkScopeResourceId!.Assign(value); }
    }
    private BicepValue<string>? _privateLinkScopeResourceId;

    /// <summary>
    /// Property which describes the state of private link on a connected
    /// cluster resource.
    /// </summary>
    public BicepValue<PrivateLinkState> PrivateLinkState 
    {
        get { Initialize(); return _privateLinkState!; }
        set { Initialize(); _privateLinkState!.Assign(value); }
    }
    private BicepValue<PrivateLinkState>? _privateLinkState;

    /// <summary>
    /// Provisioning state of the connected cluster resource.
    /// </summary>
    public BicepValue<ProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
        set { Initialize(); _provisioningState!.Assign(value); }
    }
    private BicepValue<ProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Version of the agent running on the connected cluster resource.
    /// </summary>
    public BicepValue<string> AgentVersion 
    {
        get { Initialize(); return _agentVersion!; }
    }
    private BicepValue<string>? _agentVersion;

    /// <summary>
    /// Represents the connectivity status of the connected cluster.
    /// </summary>
    public BicepValue<ConnectivityStatus> ConnectivityStatus 
    {
        get { Initialize(); return _connectivityStatus!; }
    }
    private BicepValue<ConnectivityStatus>? _connectivityStatus;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The Kubernetes version of the connected cluster resource.
    /// </summary>
    public BicepValue<string> KubernetesVersion 
    {
        get { Initialize(); return _kubernetesVersion!; }
    }
    private BicepValue<string>? _kubernetesVersion;

    /// <summary>
    /// Time representing the last instance when heart beat was received from
    /// the cluster.
    /// </summary>
    public BicepValue<DateTimeOffset> LastConnectivityOn 
    {
        get { Initialize(); return _lastConnectivityOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastConnectivityOn;

    /// <summary>
    /// Expiration time of the managed identity certificate.
    /// </summary>
    public BicepValue<DateTimeOffset> ManagedIdentityCertificateExpirationOn 
    {
        get { Initialize(); return _managedIdentityCertificateExpirationOn!; }
    }
    private BicepValue<DateTimeOffset>? _managedIdentityCertificateExpirationOn;

    /// <summary>
    /// Connected cluster offering.
    /// </summary>
    public BicepValue<string> Offering 
    {
        get { Initialize(); return _offering!; }
    }
    private BicepValue<string>? _offering;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Number of CPU cores present in the connected cluster resource.
    /// </summary>
    public BicepValue<int> TotalCoreCount 
    {
        get { Initialize(); return _totalCoreCount!; }
    }
    private BicepValue<int>? _totalCoreCount;

    /// <summary>
    /// Number of nodes present in the connected cluster resource.
    /// </summary>
    public BicepValue<int> TotalNodeCount 
    {
        get { Initialize(); return _totalNodeCount!; }
    }
    private BicepValue<int>? _totalNodeCount;

    /// <summary>
    /// Creates a new ConnectedCluster.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ConnectedCluster resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ConnectedCluster.</param>
    public ConnectedCluster(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Kubernetes/connectedClusters", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ConnectedCluster.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _agentPublicKeyCertificate = DefineProperty<string>("AgentPublicKeyCertificate", ["properties", "agentPublicKeyCertificate"], isRequired: true);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _distribution = DefineProperty<string>("Distribution", ["properties", "distribution"]);
        _infrastructure = DefineProperty<string>("Infrastructure", ["properties", "infrastructure"]);
        _privateLinkScopeResourceId = DefineProperty<string>("PrivateLinkScopeResourceId", ["properties", "privateLinkScopeResourceId"]);
        _privateLinkState = DefineProperty<PrivateLinkState>("PrivateLinkState", ["properties", "privateLinkState"]);
        _provisioningState = DefineProperty<ProvisioningState>("ProvisioningState", ["properties", "provisioningState"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _agentVersion = DefineProperty<string>("AgentVersion", ["properties", "agentVersion"], isOutput: true);
        _connectivityStatus = DefineProperty<ConnectivityStatus>("ConnectivityStatus", ["properties", "connectivityStatus"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _kubernetesVersion = DefineProperty<string>("KubernetesVersion", ["properties", "kubernetesVersion"], isOutput: true);
        _lastConnectivityOn = DefineProperty<DateTimeOffset>("LastConnectivityOn", ["properties", "lastConnectivityTime"], isOutput: true);
        _managedIdentityCertificateExpirationOn = DefineProperty<DateTimeOffset>("ManagedIdentityCertificateExpirationOn", ["properties", "managedIdentityCertificateExpirationTime"], isOutput: true);
        _offering = DefineProperty<string>("Offering", ["properties", "offering"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _totalCoreCount = DefineProperty<int>("TotalCoreCount", ["properties", "totalCoreCount"], isOutput: true);
        _totalNodeCount = DefineProperty<int>("TotalNodeCount", ["properties", "totalNodeCount"], isOutput: true);
    }

    /// <summary>
    /// Supported ConnectedCluster resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-10-01.
        /// </summary>
        public static readonly string V2021_10_01 = "2021-10-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing ConnectedCluster.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ConnectedCluster resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ConnectedCluster.</param>
    /// <returns>The existing ConnectedCluster resource.</returns>
    public static ConnectedCluster FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ConnectedCluster resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore);

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this ConnectedCluster.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(KubernetesBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{KubernetesBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// ConnectedCluster.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(KubernetesBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{KubernetesBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
