// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Properties of the secret.
/// </summary>
public partial class SecretProperties : ProvisionableConstruct
{
    /// <summary>
    /// The value of the secret. NOTE: &apos;value&apos; will never be returned
    /// from the service, as APIs using this model are is intended for
    /// internal use in ARM deployments. Users should use the data-plane REST
    /// service for interaction with vault secrets.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// The content type of the secret.
    /// </summary>
    public BicepValue<string> ContentType 
    {
        get { Initialize(); return _contentType!; }
        set { Initialize(); _contentType!.Assign(value); }
    }
    private BicepValue<string>? _contentType;

    /// <summary>
    /// The attributes of the secret.
    /// </summary>
    public SecretAttributes Attributes 
    {
        get { Initialize(); return _attributes!; }
        set { Initialize(); AssignOrReplace(ref _attributes, value); }
    }
    private SecretAttributes? _attributes;

    /// <summary>
    /// The URI to retrieve the current version of the secret.
    /// </summary>
    public BicepValue<Uri> SecretUri 
    {
        get { Initialize(); return _secretUri!; }
    }
    private BicepValue<Uri>? _secretUri;

    /// <summary>
    /// The URI to retrieve the specific version of the secret.
    /// </summary>
    public BicepValue<string> SecretUriWithVersion 
    {
        get { Initialize(); return _secretUriWithVersion!; }
    }
    private BicepValue<string>? _secretUriWithVersion;

    /// <summary>
    /// Creates a new SecretProperties.
    /// </summary>
    public SecretProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SecretProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _value = DefineProperty<string>("Value", ["value"]);
        _contentType = DefineProperty<string>("ContentType", ["contentType"]);
        _attributes = DefineModelProperty<SecretAttributes>("Attributes", ["attributes"]);
        _secretUri = DefineProperty<Uri>("SecretUri", ["secretUri"], isOutput: true);
        _secretUriWithVersion = DefineProperty<string>("SecretUriWithVersion", ["secretUriWithVersion"], isOutput: true);
    }
}
