// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// The secret management attributes.
/// </summary>
public partial class SecretAttributes : ProvisionableConstruct
{
    /// <summary>
    /// Determines whether the object is enabled.
    /// </summary>
    public BicepValue<bool> Enabled 
    {
        get { Initialize(); return _enabled!; }
        set { Initialize(); _enabled!.Assign(value); }
    }
    private BicepValue<bool>? _enabled;

    /// <summary>
    /// Not before date in seconds since 1970-01-01T00:00:00Z.
    /// </summary>
    public BicepValue<DateTimeOffset> NotBefore 
    {
        get { Initialize(); return _notBefore!; }
        set { Initialize(); _notBefore!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _notBefore;

    /// <summary>
    /// Expiry date in seconds since 1970-01-01T00:00:00Z.
    /// </summary>
    public BicepValue<DateTimeOffset> Expires 
    {
        get { Initialize(); return _expires!; }
        set { Initialize(); _expires!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _expires;

    /// <summary>
    /// Creation time in seconds since 1970-01-01T00:00:00Z.
    /// </summary>
    public BicepValue<DateTimeOffset> Created 
    {
        get { Initialize(); return _created!; }
    }
    private BicepValue<DateTimeOffset>? _created;

    /// <summary>
    /// Last updated time in seconds since 1970-01-01T00:00:00Z.
    /// </summary>
    public BicepValue<DateTimeOffset> Updated 
    {
        get { Initialize(); return _updated!; }
    }
    private BicepValue<DateTimeOffset>? _updated;

    /// <summary>
    /// Creates a new SecretAttributes.
    /// </summary>
    public SecretAttributes()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SecretAttributes.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _enabled = DefineProperty<bool>("Enabled", ["enabled"]);
        _notBefore = DefineProperty<DateTimeOffset>("NotBefore", ["nbf"]);
        _expires = DefineProperty<DateTimeOffset>("Expires", ["exp"]);
        _created = DefineProperty<DateTimeOffset>("Created", ["created"], isOutput: true);
        _updated = DefineProperty<DateTimeOffset>("Updated", ["updated"], isOutput: true);
    }
}
