// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// SKU details.
/// </summary>
public partial class ManagedHsmSku : ProvisionableConstruct
{
    /// <summary>
    /// SKU Family of the managed HSM Pool.
    /// </summary>
    public BicepValue<ManagedHsmSkuFamily> Family 
    {
        get { Initialize(); return _family!; }
        set { Initialize(); _family!.Assign(value); }
    }
    private BicepValue<ManagedHsmSkuFamily>? _family;

    /// <summary>
    /// SKU of the managed HSM Pool.
    /// </summary>
    public BicepValue<ManagedHsmSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<ManagedHsmSkuName>? _name;

    /// <summary>
    /// Creates a new ManagedHsmSku.
    /// </summary>
    public ManagedHsmSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedHsmSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _family = DefineProperty<ManagedHsmSkuFamily>("Family", ["family"]);
        _name = DefineProperty<ManagedHsmSkuName>("Name", ["name"]);
    }
}
