// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Provisioning state.
/// </summary>
public enum ManagedHsmProvisioningState
{
    /// <summary>
    /// The managed HSM Pool has been full provisioned.
    /// </summary>
    Succeeded,

    /// <summary>
    /// The managed HSM Pool is currently being provisioned.
    /// </summary>
    Provisioning,

    /// <summary>
    /// Provisioning of the managed HSM Pool has failed.
    /// </summary>
    Failed,

    /// <summary>
    /// The managed HSM Pool is currently being updated.
    /// </summary>
    Updating,

    /// <summary>
    /// The managed HSM Pool is currently being deleted.
    /// </summary>
    Deleting,

    /// <summary>
    /// The managed HSM pool is ready for normal use.
    /// </summary>
    Activated,

    /// <summary>
    /// The managed HSM pool is waiting for a security domain restore action.
    /// </summary>
    SecurityDomainRestore,

    /// <summary>
    /// The managed HSM pool is being restored from full HSM backup.
    /// </summary>
    Restoring,
}
