// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Properties of the managed HSM Pool.
/// </summary>
public partial class ManagedHsmProperties : ProvisionableConstruct
{
    /// <summary>
    /// The Azure Active Directory tenant ID that should be used for
    /// authenticating requests to the managed HSM pool.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Array of initial administrators object ids for this managed hsm pool.
    /// </summary>
    public BicepList<string> InitialAdminObjectIds 
    {
        get { Initialize(); return _initialAdminObjectIds!; }
        set { Initialize(); _initialAdminObjectIds!.Assign(value); }
    }
    private BicepList<string>? _initialAdminObjectIds;

    /// <summary>
    /// The URI of the managed hsm pool for performing operations on keys.
    /// </summary>
    public BicepValue<Uri> HsmUri 
    {
        get { Initialize(); return _hsmUri!; }
    }
    private BicepValue<Uri>? _hsmUri;

    /// <summary>
    /// Property to specify whether the &apos;soft delete&apos; functionality
    /// is enabled for this managed HSM pool. Soft delete is enabled by
    /// default for all managed HSMs and is immutable.
    /// </summary>
    public BicepValue<bool> EnableSoftDelete 
    {
        get { Initialize(); return _enableSoftDelete!; }
        set { Initialize(); _enableSoftDelete!.Assign(value); }
    }
    private BicepValue<bool>? _enableSoftDelete;

    /// <summary>
    /// Soft deleted data retention days. When you delete an HSM or a key, it
    /// will remain recoverable for the configured retention period or for a
    /// default period of 90 days. It accepts values between 7 and 90.
    /// </summary>
    public BicepValue<int> SoftDeleteRetentionInDays 
    {
        get { Initialize(); return _softDeleteRetentionInDays!; }
        set { Initialize(); _softDeleteRetentionInDays!.Assign(value); }
    }
    private BicepValue<int>? _softDeleteRetentionInDays;

    /// <summary>
    /// Property specifying whether protection against purge is enabled for
    /// this managed HSM pool. Setting this property to true activates
    /// protection against purge for this managed HSM pool and its content -
    /// only the Managed HSM service may initiate a hard, irrecoverable
    /// deletion. Enabling this functionality is irreversible.
    /// </summary>
    public BicepValue<bool> EnablePurgeProtection 
    {
        get { Initialize(); return _enablePurgeProtection!; }
        set { Initialize(); _enablePurgeProtection!.Assign(value); }
    }
    private BicepValue<bool>? _enablePurgeProtection;

    /// <summary>
    /// The create mode to indicate whether the resource is being created or is
    /// being recovered from a deleted resource.
    /// </summary>
    public BicepValue<ManagedHsmCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<ManagedHsmCreateMode>? _createMode;

    /// <summary>
    /// Resource Status Message.
    /// </summary>
    public BicepValue<string> StatusMessage 
    {
        get { Initialize(); return _statusMessage!; }
    }
    private BicepValue<string>? _statusMessage;

    /// <summary>
    /// Provisioning state.
    /// </summary>
    public BicepValue<ManagedHsmProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ManagedHsmProvisioningState>? _provisioningState;

    /// <summary>
    /// Rules governing the accessibility of the key vault from specific
    /// network locations.
    /// </summary>
    public ManagedHsmNetworkRuleSet NetworkRuleSet 
    {
        get { Initialize(); return _networkRuleSet!; }
        set { Initialize(); AssignOrReplace(ref _networkRuleSet, value); }
    }
    private ManagedHsmNetworkRuleSet? _networkRuleSet;

    /// <summary>
    /// List of all regions associated with the managed hsm pool.
    /// </summary>
    public BicepList<ManagedHsmGeoReplicatedRegion> Regions 
    {
        get { Initialize(); return _regions!; }
        set { Initialize(); _regions!.Assign(value); }
    }
    private BicepList<ManagedHsmGeoReplicatedRegion>? _regions;

    /// <summary>
    /// List of private endpoint connections associated with the managed hsm
    /// pool.
    /// </summary>
    public BicepList<ManagedHsmPrivateEndpointConnectionItemData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<ManagedHsmPrivateEndpointConnectionItemData>? _privateEndpointConnections;

    /// <summary>
    /// Control permission to the managed HSM from public networks.
    /// </summary>
    public BicepValue<ManagedHsmPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<ManagedHsmPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// The scheduled purge date in UTC.
    /// </summary>
    public BicepValue<DateTimeOffset> ScheduledPurgeOn 
    {
        get { Initialize(); return _scheduledPurgeOn!; }
    }
    private BicepValue<DateTimeOffset>? _scheduledPurgeOn;

    /// <summary>
    /// Managed HSM security domain properties.
    /// </summary>
    public ManagedHSMSecurityDomainProperties SecurityDomainProperties 
    {
        get { Initialize(); return _securityDomainProperties!; }
    }
    private ManagedHSMSecurityDomainProperties? _securityDomainProperties;

    /// <summary>
    /// Creates a new ManagedHsmProperties.
    /// </summary>
    public ManagedHsmProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedHsmProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _initialAdminObjectIds = DefineListProperty<string>("InitialAdminObjectIds", ["initialAdminObjectIds"]);
        _hsmUri = DefineProperty<Uri>("HsmUri", ["hsmUri"], isOutput: true);
        _enableSoftDelete = DefineProperty<bool>("EnableSoftDelete", ["enableSoftDelete"]);
        _softDeleteRetentionInDays = DefineProperty<int>("SoftDeleteRetentionInDays", ["softDeleteRetentionInDays"]);
        _enablePurgeProtection = DefineProperty<bool>("EnablePurgeProtection", ["enablePurgeProtection"]);
        _createMode = DefineProperty<ManagedHsmCreateMode>("CreateMode", ["createMode"]);
        _statusMessage = DefineProperty<string>("StatusMessage", ["statusMessage"], isOutput: true);
        _provisioningState = DefineProperty<ManagedHsmProvisioningState>("ProvisioningState", ["provisioningState"], isOutput: true);
        _networkRuleSet = DefineModelProperty<ManagedHsmNetworkRuleSet>("NetworkRuleSet", ["networkAcls"]);
        _regions = DefineListProperty<ManagedHsmGeoReplicatedRegion>("Regions", ["regions"]);
        _privateEndpointConnections = DefineListProperty<ManagedHsmPrivateEndpointConnectionItemData>("PrivateEndpointConnections", ["privateEndpointConnections"], isOutput: true);
        _publicNetworkAccess = DefineProperty<ManagedHsmPublicNetworkAccess>("PublicNetworkAccess", ["publicNetworkAccess"]);
        _scheduledPurgeOn = DefineProperty<DateTimeOffset>("ScheduledPurgeOn", ["scheduledPurgeDate"], isOutput: true);
        _securityDomainProperties = DefineModelProperty<ManagedHSMSecurityDomainProperties>("SecurityDomainProperties", ["securityDomainProperties"], isOutput: true);
    }
}
