// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// An object that represents the approval state of the private link connection.
/// </summary>
public partial class ManagedHsmPrivateLinkServiceConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// Indicates whether the connection has been approved, rejected or removed
    /// by the key vault owner.
    /// </summary>
    public BicepValue<ManagedHsmPrivateEndpointServiceConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ManagedHsmPrivateEndpointServiceConnectionStatus>? _status;

    /// <summary>
    /// The reason for approval or rejection.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// A message indicating if changes on the service provider require any
    /// updates on the consumer.
    /// </summary>
    public BicepValue<ManagedHsmActionsRequiredMessage> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
        set { Initialize(); _actionsRequired!.Assign(value); }
    }
    private BicepValue<ManagedHsmActionsRequiredMessage>? _actionsRequired;

    /// <summary>
    /// Creates a new ManagedHsmPrivateLinkServiceConnectionState.
    /// </summary>
    public ManagedHsmPrivateLinkServiceConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedHsmPrivateLinkServiceConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<ManagedHsmPrivateEndpointServiceConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<ManagedHsmActionsRequiredMessage>("ActionsRequired", ["actionsRequired"]);
    }
}
