// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Private endpoint connection item.
/// </summary>
public partial class ManagedHsmPrivateEndpointConnectionItemData : ProvisionableConstruct
{
    /// <summary>
    /// Id of private endpoint connection.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Modified whenever there is a change in the state of private endpoint
    /// connection.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Gets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateEndpointId 
    {
        get { Initialize(); return _privateEndpointId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateEndpointId;

    /// <summary>
    /// Approval state of the private link connection.
    /// </summary>
    public ManagedHsmPrivateLinkServiceConnectionState PrivateLinkServiceConnectionState 
    {
        get { Initialize(); return _privateLinkServiceConnectionState!; }
    }
    private ManagedHsmPrivateLinkServiceConnectionState? _privateLinkServiceConnectionState;

    /// <summary>
    /// Provisioning state of the private endpoint connection.
    /// </summary>
    public BicepValue<ManagedHsmPrivateEndpointConnectionProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ManagedHsmPrivateEndpointConnectionProvisioningState>? _provisioningState;

    /// <summary>
    /// Creates a new ManagedHsmPrivateEndpointConnectionItemData.
    /// </summary>
    public ManagedHsmPrivateEndpointConnectionItemData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedHsmPrivateEndpointConnectionItemData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["etag"], isOutput: true);
        _privateEndpointId = DefineProperty<ResourceIdentifier>("PrivateEndpointId", ["properties", "privateEndpoint", "id"], isOutput: true);
        _privateLinkServiceConnectionState = DefineModelProperty<ManagedHsmPrivateLinkServiceConnectionState>("PrivateLinkServiceConnectionState", ["properties", "privateLinkServiceConnectionState"], isOutput: true);
        _provisioningState = DefineProperty<ManagedHsmPrivateEndpointConnectionProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
    }
}
