// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// A set of rules governing the network accessibility of a managed hsm pool.
/// </summary>
public partial class ManagedHsmNetworkRuleSet : ProvisionableConstruct
{
    /// <summary>
    /// Tells what traffic can bypass network rules. This can be
    /// &apos;AzureServices&apos; or &apos;None&apos;.  If not specified the
    /// default is &apos;AzureServices&apos;.
    /// </summary>
    public BicepValue<ManagedHsmNetworkRuleBypassOption> Bypass 
    {
        get { Initialize(); return _bypass!; }
        set { Initialize(); _bypass!.Assign(value); }
    }
    private BicepValue<ManagedHsmNetworkRuleBypassOption>? _bypass;

    /// <summary>
    /// The default action when no rule from ipRules and from
    /// virtualNetworkRules match. This is only used after the bypass property
    /// has been evaluated.
    /// </summary>
    public BicepValue<ManagedHsmNetworkRuleAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<ManagedHsmNetworkRuleAction>? _defaultAction;

    /// <summary>
    /// The list of IP address rules.
    /// </summary>
    public BicepList<ManagedHsmIPRule> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<ManagedHsmIPRule>? _iPRules;

    /// <summary>
    /// The list of virtual network rules.
    /// </summary>
    public BicepList<ManagedHsmVirtualNetworkRule> VirtualNetworkRules 
    {
        get { Initialize(); return _virtualNetworkRules!; }
        set { Initialize(); _virtualNetworkRules!.Assign(value); }
    }
    private BicepList<ManagedHsmVirtualNetworkRule>? _virtualNetworkRules;

    /// <summary>
    /// Creates a new ManagedHsmNetworkRuleSet.
    /// </summary>
    public ManagedHsmNetworkRuleSet()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedHsmNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _bypass = DefineProperty<ManagedHsmNetworkRuleBypassOption>("Bypass", ["bypass"]);
        _defaultAction = DefineProperty<ManagedHsmNetworkRuleAction>("DefaultAction", ["defaultAction"]);
        _iPRules = DefineListProperty<ManagedHsmIPRule>("IPRules", ["ipRules"]);
        _virtualNetworkRules = DefineListProperty<ManagedHsmVirtualNetworkRule>("VirtualNetworkRules", ["virtualNetworkRules"]);
    }
}
