// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// The security domain properties of the managed hsm.
/// </summary>
public partial class ManagedHSMSecurityDomainProperties : ProvisionableConstruct
{
    /// <summary>
    /// Activation Status.
    /// </summary>
    public BicepValue<ManagedHSMSecurityDomainActivationStatus> ActivationStatus 
    {
        get { Initialize(); return _activationStatus!; }
    }
    private BicepValue<ManagedHSMSecurityDomainActivationStatus>? _activationStatus;

    /// <summary>
    /// Activation Status Message.
    /// </summary>
    public BicepValue<string> ActivationStatusMessage 
    {
        get { Initialize(); return _activationStatusMessage!; }
    }
    private BicepValue<string>? _activationStatusMessage;

    /// <summary>
    /// Creates a new ManagedHSMSecurityDomainProperties.
    /// </summary>
    public ManagedHSMSecurityDomainProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedHSMSecurityDomainProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _activationStatus = DefineProperty<ManagedHSMSecurityDomainActivationStatus>("ActivationStatus", ["activationStatus"], isOutput: true);
        _activationStatusMessage = DefineProperty<string>("ActivationStatusMessage", ["activationStatusMessage"], isOutput: true);
    }
}
