// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// A rule governing the accessibility of a vault from a specific virtual
/// network.
/// </summary>
public partial class KeyVaultVirtualNetworkRule : ProvisionableConstruct
{
    /// <summary>
    /// Full resource id of a vnet subnet, such as
    /// &apos;/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1&apos;.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// Property to specify whether NRP will ignore the check if parent subnet
    /// has serviceEndpoints configured.
    /// </summary>
    public BicepValue<bool> IgnoreMissingVnetServiceEndpoint 
    {
        get { Initialize(); return _ignoreMissingVnetServiceEndpoint!; }
        set { Initialize(); _ignoreMissingVnetServiceEndpoint!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreMissingVnetServiceEndpoint;

    /// <summary>
    /// Creates a new KeyVaultVirtualNetworkRule.
    /// </summary>
    public KeyVaultVirtualNetworkRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KeyVaultVirtualNetworkRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _ignoreMissingVnetServiceEndpoint = DefineProperty<bool>("IgnoreMissingVnetServiceEndpoint", ["ignoreMissingVnetServiceEndpoint"]);
    }
}
