// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// SKU details.
/// </summary>
public partial class KeyVaultSku : ProvisionableConstruct
{
    /// <summary>
    /// SKU family name.
    /// </summary>
    public BicepValue<KeyVaultSkuFamily> Family 
    {
        get { Initialize(); return _family!; }
        set { Initialize(); _family!.Assign(value); }
    }
    private BicepValue<KeyVaultSkuFamily>? _family;

    /// <summary>
    /// SKU name to specify whether the key vault is a standard vault or a
    /// premium vault.
    /// </summary>
    public BicepValue<KeyVaultSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<KeyVaultSkuName>? _name;

    /// <summary>
    /// Creates a new KeyVaultSku.
    /// </summary>
    public KeyVaultSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KeyVaultSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _family = DefineProperty<KeyVaultSkuFamily>("Family", ["family"]);
        _name = DefineProperty<KeyVaultSkuName>("Name", ["name"]);
    }
}
