// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Properties of the vault.
/// </summary>
public partial class KeyVaultProperties : ProvisionableConstruct
{
    /// <summary>
    /// The Azure Active Directory tenant ID that should be used for
    /// authenticating requests to the key vault.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// SKU details.
    /// </summary>
    public KeyVaultSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private KeyVaultSku? _sku;

    /// <summary>
    /// An array of 0 to 1024 identities that have access to the key vault. All
    /// identities in the array must use the same tenant ID as the key
    /// vault&apos;s tenant ID. When `createMode` is set to `recover`, access
    /// policies are not required. Otherwise, access policies are required.
    /// </summary>
    public BicepList<KeyVaultAccessPolicy> AccessPolicies 
    {
        get { Initialize(); return _accessPolicies!; }
        set { Initialize(); _accessPolicies!.Assign(value); }
    }
    private BicepList<KeyVaultAccessPolicy>? _accessPolicies;

    /// <summary>
    /// The URI of the vault for performing operations on keys and secrets.
    /// </summary>
    public BicepValue<Uri> VaultUri 
    {
        get { Initialize(); return _vaultUri!; }
        set { Initialize(); _vaultUri!.Assign(value); }
    }
    private BicepValue<Uri>? _vaultUri;

    /// <summary>
    /// The resource id of HSM Pool.
    /// </summary>
    public BicepValue<string> HsmPoolResourceId 
    {
        get { Initialize(); return _hsmPoolResourceId!; }
    }
    private BicepValue<string>? _hsmPoolResourceId;

    /// <summary>
    /// Property to specify whether Azure Virtual Machines are permitted to
    /// retrieve certificates stored as secrets from the key vault.
    /// </summary>
    public BicepValue<bool> EnabledForDeployment 
    {
        get { Initialize(); return _enabledForDeployment!; }
        set { Initialize(); _enabledForDeployment!.Assign(value); }
    }
    private BicepValue<bool>? _enabledForDeployment;

    /// <summary>
    /// Property to specify whether Azure Disk Encryption is permitted to
    /// retrieve secrets from the vault and unwrap keys.
    /// </summary>
    public BicepValue<bool> EnabledForDiskEncryption 
    {
        get { Initialize(); return _enabledForDiskEncryption!; }
        set { Initialize(); _enabledForDiskEncryption!.Assign(value); }
    }
    private BicepValue<bool>? _enabledForDiskEncryption;

    /// <summary>
    /// Property to specify whether Azure Resource Manager is permitted to
    /// retrieve secrets from the key vault.
    /// </summary>
    public BicepValue<bool> EnabledForTemplateDeployment 
    {
        get { Initialize(); return _enabledForTemplateDeployment!; }
        set { Initialize(); _enabledForTemplateDeployment!.Assign(value); }
    }
    private BicepValue<bool>? _enabledForTemplateDeployment;

    /// <summary>
    /// Property to specify whether the &apos;soft delete&apos; functionality
    /// is enabled for this key vault. If it&apos;s not set to any value(true
    /// or false) when creating new key vault, it will be set to true by
    /// default. Once set to true, it cannot be reverted to false.
    /// </summary>
    public BicepValue<bool> EnableSoftDelete 
    {
        get { Initialize(); return _enableSoftDelete!; }
        set { Initialize(); _enableSoftDelete!.Assign(value); }
    }
    private BicepValue<bool>? _enableSoftDelete;

    /// <summary>
    /// softDelete data retention days. It accepts &gt;=7 and &lt;=90.
    /// </summary>
    public BicepValue<int> SoftDeleteRetentionInDays 
    {
        get { Initialize(); return _softDeleteRetentionInDays!; }
        set { Initialize(); _softDeleteRetentionInDays!.Assign(value); }
    }
    private BicepValue<int>? _softDeleteRetentionInDays;

    /// <summary>
    /// Property that controls how data actions are authorized. When true, the
    /// key vault will use Role Based Access Control (RBAC) for authorization
    /// of data actions, and the access policies specified in vault properties
    /// will be  ignored. When false, the key vault will use the access
    /// policies specified in vault properties, and any policy stored on Azure
    /// Resource Manager will be ignored. If null or not specified, the vault
    /// is created with the default value of false. Note that management
    /// actions are always authorized with RBAC.
    /// </summary>
    public BicepValue<bool> EnableRbacAuthorization 
    {
        get { Initialize(); return _enableRbacAuthorization!; }
        set { Initialize(); _enableRbacAuthorization!.Assign(value); }
    }
    private BicepValue<bool>? _enableRbacAuthorization;

    /// <summary>
    /// The vault&apos;s create mode to indicate whether the vault need to be
    /// recovered or not.
    /// </summary>
    public BicepValue<KeyVaultCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<KeyVaultCreateMode>? _createMode;

    /// <summary>
    /// Property specifying whether protection against purge is enabled for
    /// this vault. Setting this property to true activates protection against
    /// purge for this vault and its content - only the Key Vault service may
    /// initiate a hard, irrecoverable deletion. The setting is effective only
    /// if soft delete is also enabled. Enabling this functionality is
    /// irreversible - that is, the property does not accept false as its
    /// value.
    /// </summary>
    public BicepValue<bool> EnablePurgeProtection 
    {
        get { Initialize(); return _enablePurgeProtection!; }
        set { Initialize(); _enablePurgeProtection!.Assign(value); }
    }
    private BicepValue<bool>? _enablePurgeProtection;

    /// <summary>
    /// Rules governing the accessibility of the key vault from specific
    /// network locations.
    /// </summary>
    public KeyVaultNetworkRuleSet NetworkRuleSet 
    {
        get { Initialize(); return _networkRuleSet!; }
        set { Initialize(); AssignOrReplace(ref _networkRuleSet, value); }
    }
    private KeyVaultNetworkRuleSet? _networkRuleSet;

    /// <summary>
    /// Provisioning state of the vault.
    /// </summary>
    public BicepValue<KeyVaultProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
        set { Initialize(); _provisioningState!.Assign(value); }
    }
    private BicepValue<KeyVaultProvisioningState>? _provisioningState;

    /// <summary>
    /// List of private endpoint connections associated with the key vault.
    /// </summary>
    public BicepList<KeyVaultPrivateEndpointConnectionItemData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<KeyVaultPrivateEndpointConnectionItemData>? _privateEndpointConnections;

    /// <summary>
    /// Property to specify whether the vault will accept traffic from public
    /// internet. If set to &apos;disabled&apos; all traffic except private
    /// endpoint traffic and that that originates from trusted services will
    /// be blocked. This will override the set firewall rules, meaning that
    /// even if the firewall rules are present we will not honor the rules.
    /// </summary>
    public BicepValue<string> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<string>? _publicNetworkAccess;

    /// <summary>
    /// Creates a new KeyVaultProperties.
    /// </summary>
    public KeyVaultProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KeyVaultProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _sku = DefineModelProperty<KeyVaultSku>("Sku", ["sku"]);
        _accessPolicies = DefineListProperty<KeyVaultAccessPolicy>("AccessPolicies", ["accessPolicies"]);
        _vaultUri = DefineProperty<Uri>("VaultUri", ["vaultUri"]);
        _hsmPoolResourceId = DefineProperty<string>("HsmPoolResourceId", ["hsmPoolResourceId"], isOutput: true);
        _enabledForDeployment = DefineProperty<bool>("EnabledForDeployment", ["enabledForDeployment"]);
        _enabledForDiskEncryption = DefineProperty<bool>("EnabledForDiskEncryption", ["enabledForDiskEncryption"]);
        _enabledForTemplateDeployment = DefineProperty<bool>("EnabledForTemplateDeployment", ["enabledForTemplateDeployment"]);
        _enableSoftDelete = DefineProperty<bool>("EnableSoftDelete", ["enableSoftDelete"]);
        _softDeleteRetentionInDays = DefineProperty<int>("SoftDeleteRetentionInDays", ["softDeleteRetentionInDays"]);
        _enableRbacAuthorization = DefineProperty<bool>("EnableRbacAuthorization", ["enableRbacAuthorization"]);
        _createMode = DefineProperty<KeyVaultCreateMode>("CreateMode", ["createMode"]);
        _enablePurgeProtection = DefineProperty<bool>("EnablePurgeProtection", ["enablePurgeProtection"]);
        _networkRuleSet = DefineModelProperty<KeyVaultNetworkRuleSet>("NetworkRuleSet", ["networkAcls"]);
        _provisioningState = DefineProperty<KeyVaultProvisioningState>("ProvisioningState", ["provisioningState"]);
        _privateEndpointConnections = DefineListProperty<KeyVaultPrivateEndpointConnectionItemData>("PrivateEndpointConnections", ["privateEndpointConnections"], isOutput: true);
        _publicNetworkAccess = DefineProperty<string>("PublicNetworkAccess", ["publicNetworkAccess"]);
    }
}
