// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// An object that represents the approval state of the private link connection.
/// </summary>
public partial class KeyVaultPrivateLinkServiceConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// Indicates whether the connection has been approved, rejected or removed
    /// by the key vault owner.
    /// </summary>
    public BicepValue<KeyVaultPrivateEndpointServiceConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<KeyVaultPrivateEndpointServiceConnectionStatus>? _status;

    /// <summary>
    /// The reason for approval or rejection.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// A message indicating if changes on the service provider require any
    /// updates on the consumer.
    /// </summary>
    public BicepValue<KeyVaultActionsRequiredMessage> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
        set { Initialize(); _actionsRequired!.Assign(value); }
    }
    private BicepValue<KeyVaultActionsRequiredMessage>? _actionsRequired;

    /// <summary>
    /// Creates a new KeyVaultPrivateLinkServiceConnectionState.
    /// </summary>
    public KeyVaultPrivateLinkServiceConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// KeyVaultPrivateLinkServiceConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<KeyVaultPrivateEndpointServiceConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<KeyVaultActionsRequiredMessage>("ActionsRequired", ["actionsRequired"]);
    }
}
