// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Private endpoint connection item.
/// </summary>
public partial class KeyVaultPrivateEndpointConnectionItemData : ProvisionableConstruct
{
    /// <summary>
    /// Id of private endpoint connection.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// Modified whenever there is a change in the state of private endpoint
    /// connection.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Gets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateEndpointId 
    {
        get { Initialize(); return _privateEndpointId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateEndpointId;

    /// <summary>
    /// Approval state of the private link connection.
    /// </summary>
    public KeyVaultPrivateLinkServiceConnectionState ConnectionState 
    {
        get { Initialize(); return _connectionState!; }
    }
    private KeyVaultPrivateLinkServiceConnectionState? _connectionState;

    /// <summary>
    /// Provisioning state of the private endpoint connection.
    /// </summary>
    public BicepValue<KeyVaultPrivateEndpointConnectionProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<KeyVaultPrivateEndpointConnectionProvisioningState>? _provisioningState;

    /// <summary>
    /// Creates a new KeyVaultPrivateEndpointConnectionItemData.
    /// </summary>
    public KeyVaultPrivateEndpointConnectionItemData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// KeyVaultPrivateEndpointConnectionItemData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["etag"], isOutput: true);
        _privateEndpointId = DefineProperty<ResourceIdentifier>("PrivateEndpointId", ["properties", "privateEndpoint", "id"], isOutput: true);
        _connectionState = DefineModelProperty<KeyVaultPrivateLinkServiceConnectionState>("ConnectionState", ["properties", "privateLinkServiceConnectionState"], isOutput: true);
        _provisioningState = DefineProperty<KeyVaultPrivateEndpointConnectionProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
    }
}
