// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// A set of rules governing the network accessibility of a vault.
/// </summary>
public partial class KeyVaultNetworkRuleSet : ProvisionableConstruct
{
    /// <summary>
    /// Tells what traffic can bypass network rules. This can be
    /// &apos;AzureServices&apos; or &apos;None&apos;.  If not specified the
    /// default is &apos;AzureServices&apos;.
    /// </summary>
    public BicepValue<KeyVaultNetworkRuleBypassOption> Bypass 
    {
        get { Initialize(); return _bypass!; }
        set { Initialize(); _bypass!.Assign(value); }
    }
    private BicepValue<KeyVaultNetworkRuleBypassOption>? _bypass;

    /// <summary>
    /// The default action when no rule from ipRules and from
    /// virtualNetworkRules match. This is only used after the bypass property
    /// has been evaluated.
    /// </summary>
    public BicepValue<KeyVaultNetworkRuleAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<KeyVaultNetworkRuleAction>? _defaultAction;

    /// <summary>
    /// The list of IP address rules.
    /// </summary>
    public BicepList<KeyVaultIPRule> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<KeyVaultIPRule>? _iPRules;

    /// <summary>
    /// The list of virtual network rules.
    /// </summary>
    public BicepList<KeyVaultVirtualNetworkRule> VirtualNetworkRules 
    {
        get { Initialize(); return _virtualNetworkRules!; }
        set { Initialize(); _virtualNetworkRules!.Assign(value); }
    }
    private BicepList<KeyVaultVirtualNetworkRule>? _virtualNetworkRules;

    /// <summary>
    /// Creates a new KeyVaultNetworkRuleSet.
    /// </summary>
    public KeyVaultNetworkRuleSet()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KeyVaultNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _bypass = DefineProperty<KeyVaultNetworkRuleBypassOption>("Bypass", ["bypass"]);
        _defaultAction = DefineProperty<KeyVaultNetworkRuleAction>("DefaultAction", ["defaultAction"]);
        _iPRules = DefineListProperty<KeyVaultIPRule>("IPRules", ["ipRules"]);
        _virtualNetworkRules = DefineListProperty<KeyVaultVirtualNetworkRule>("VirtualNetworkRules", ["virtualNetworkRules"]);
    }
}
