// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// A rule governing the accessibility of a vault from a specific ip address or
/// ip range.
/// </summary>
public partial class KeyVaultIPRule : ProvisionableConstruct
{
    /// <summary>
    /// An IPv4 address range in CIDR notation, such as
    /// &apos;124.56.78.91&apos; (simple IP address) or
    /// &apos;124.56.78.0/24&apos; (all addresses that start with 124.56.78).
    /// </summary>
    public BicepValue<string> AddressRange 
    {
        get { Initialize(); return _addressRange!; }
        set { Initialize(); _addressRange!.Assign(value); }
    }
    private BicepValue<string>? _addressRange;

    /// <summary>
    /// Creates a new KeyVaultIPRule.
    /// </summary>
    public KeyVaultIPRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KeyVaultIPRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _addressRange = DefineProperty<string>("AddressRange", ["value"]);
    }
}
