// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// An identity that have access to the key vault. All identities in the array
/// must use the same tenant ID as the key vault&apos;s tenant ID.
/// </summary>
public partial class KeyVaultAccessPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The Azure Active Directory tenant ID that should be used for
    /// authenticating requests to the key vault.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// The object ID of a user, service principal or security group in the
    /// Azure Active Directory tenant for the vault. The object ID must be
    /// unique for the list of access policies.
    /// </summary>
    public BicepValue<string> ObjectId 
    {
        get { Initialize(); return _objectId!; }
        set { Initialize(); _objectId!.Assign(value); }
    }
    private BicepValue<string>? _objectId;

    /// <summary>
    /// Application ID of the client making request on behalf of a principal.
    /// </summary>
    public BicepValue<Guid> ApplicationId 
    {
        get { Initialize(); return _applicationId!; }
        set { Initialize(); _applicationId!.Assign(value); }
    }
    private BicepValue<Guid>? _applicationId;

    /// <summary>
    /// Permissions the identity has for keys, secrets and certificates.
    /// </summary>
    public IdentityAccessPermissions Permissions 
    {
        get { Initialize(); return _permissions!; }
        set { Initialize(); AssignOrReplace(ref _permissions, value); }
    }
    private IdentityAccessPermissions? _permissions;

    /// <summary>
    /// Creates a new KeyVaultAccessPolicy.
    /// </summary>
    public KeyVaultAccessPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KeyVaultAccessPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _objectId = DefineProperty<string>("ObjectId", ["objectId"]);
        _applicationId = DefineProperty<Guid>("ApplicationId", ["applicationId"]);
        _permissions = DefineModelProperty<IdentityAccessPermissions>("Permissions", ["permissions"]);
    }
}
