// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.KeyVault;

/// <summary>
/// Built-in KeyVault roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct KeyVaultBuiltInRole(string value) : IEquatable<KeyVaultBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Perform all data plane operations on a key vault and all objects in it,
    /// including certificates, keys, and secrets. Cannot manage key vault
    /// resources or manage role assignments. Only works for key vaults that
    /// use the &apos;Azure role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultAdministrator { get; } = new(KeyVaultAdministratorValue);
    internal const string KeyVaultAdministratorValue = "00482a5a-887f-4fb3-b363-3b7fe8e74483";

    /// <summary>
    /// Read certificate contents. Only works for key vaults that use the
    /// &apos;Azure role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultCertificateUser { get; } = new(KeyVaultCertificateUserValue);
    internal const string KeyVaultCertificateUserValue = "db79e9a7-68ee-4b58-9aeb-b90e7c24fcba";

    /// <summary>
    /// Perform any action on the certificates of a key vault, except manage
    /// permissions. Only works for key vaults that use the &apos;Azure
    /// role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultCertificatesOfficer { get; } = new(KeyVaultCertificatesOfficerValue);
    internal const string KeyVaultCertificatesOfficerValue = "a4417e6f-fecd-4de8-b567-7b0420556985";

    /// <summary>
    /// Manage key vaults, but does not allow you to assign roles in Azure
    /// RBAC, and does not allow you to access secrets, keys, or certificates.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultContributor { get; } = new(KeyVaultContributorValue);
    internal const string KeyVaultContributorValue = "f25e0fa2-a7c8-4377-a976-54943a77a395";

    /// <summary>
    /// Perform any action on the keys of a key vault, except manage
    /// permissions. Only works for key vaults that use the &apos;Azure
    /// role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultCryptoOfficer { get; } = new(KeyVaultCryptoOfficerValue);
    internal const string KeyVaultCryptoOfficerValue = "14b46e9e-c2b7-41b4-b07b-48a6ebf60603";

    /// <summary>
    /// Read metadata of keys and perform wrap/unwrap operations. Only works
    /// for key vaults that use the &apos;Azure role-based access
    /// control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultCryptoServiceEncryptionUser { get; } = new(KeyVaultCryptoServiceEncryptionUserValue);
    internal const string KeyVaultCryptoServiceEncryptionUserValue = "e147488a-f6f5-4113-8e2d-b22465e65bf6";

    /// <summary>
    /// Release keys. Only works for key vaults that use the &apos;Azure
    /// role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultCryptoServiceReleaseUser { get; } = new(KeyVaultCryptoServiceReleaseUserValue);
    internal const string KeyVaultCryptoServiceReleaseUserValue = "08bbd89e-9f13-488c-ac41-acfcb10c90ab";

    /// <summary>
    /// Perform cryptographic operations using keys. Only works for key vaults
    /// that use the &apos;Azure role-based access control&apos; permission
    /// model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultCryptoUser { get; } = new(KeyVaultCryptoUserValue);
    internal const string KeyVaultCryptoUserValue = "12338af0-0e69-4776-bea7-57ae8d297424";

    /// <summary>
    /// Manage access to Azure Key Vault by adding or removing role assignments
    /// for the Key Vault Administrator, Key Vault Certificates Officer, Key
    /// Vault Crypto Officer, Key Vault Crypto Service Encryption User, Key
    /// Vault Crypto User, Key Vault Reader, Key Vault Secrets Officer, or Key
    /// Vault Secrets User roles. Includes an ABAC condition to constrain role
    /// assignments.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultDataAccessAdministrator { get; } = new(KeyVaultDataAccessAdministratorValue);
    internal const string KeyVaultDataAccessAdministratorValue = "8b54135c-b56d-4d72-a534-26097cfdc8d8";

    /// <summary>
    /// Read metadata of key vaults and its certificates, keys, and secrets.
    /// Cannot read sensitive values such as secret contents or key material.
    /// Only works for key vaults that use the &apos;Azure role-based access
    /// control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultReader { get; } = new(KeyVaultReaderValue);
    internal const string KeyVaultReaderValue = "21090545-7ca7-4776-b22c-e363652d74d2";

    /// <summary>
    /// Perform any action on the secrets of a key vault, except manage
    /// permissions. Only works for key vaults that use the &apos;Azure
    /// role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultSecretsOfficer { get; } = new(KeyVaultSecretsOfficerValue);
    internal const string KeyVaultSecretsOfficerValue = "b86a8fe4-44ce-4948-aee5-eccb2c155cd7";

    /// <summary>
    /// Read secret contents. Only works for key vaults that use the
    /// &apos;Azure role-based access control&apos; permission model.
    /// </summary>
    public static KeyVaultBuiltInRole KeyVaultSecretsUser { get; } = new(KeyVaultSecretsUserValue);
    internal const string KeyVaultSecretsUserValue = "4633458b-17de-408a-b874-0445c86b69e6";

    /// <summary>
    /// Lets you manage managed HSM pools, but not access to them.
    /// </summary>
    public static KeyVaultBuiltInRole ManagedHsmContributor { get; } = new(ManagedHsmContributorValue);
    internal const string ManagedHsmContributorValue = "18500a29-7fe2-46b2-a342-b16a415e101d";

    /// <summary>
    /// Try to get the name of a built-in KeyVault role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in KeyVault role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(KeyVaultBuiltInRole value) =>
        value._value switch
        {
            KeyVaultAdministratorValue => nameof(KeyVaultAdministrator),
            KeyVaultCertificateUserValue => nameof(KeyVaultCertificateUser),
            KeyVaultCertificatesOfficerValue => nameof(KeyVaultCertificatesOfficer),
            KeyVaultContributorValue => nameof(KeyVaultContributor),
            KeyVaultCryptoOfficerValue => nameof(KeyVaultCryptoOfficer),
            KeyVaultCryptoServiceEncryptionUserValue => nameof(KeyVaultCryptoServiceEncryptionUser),
            KeyVaultCryptoServiceReleaseUserValue => nameof(KeyVaultCryptoServiceReleaseUser),
            KeyVaultCryptoUserValue => nameof(KeyVaultCryptoUser),
            KeyVaultDataAccessAdministratorValue => nameof(KeyVaultDataAccessAdministrator),
            KeyVaultReaderValue => nameof(KeyVaultReader),
            KeyVaultSecretsOfficerValue => nameof(KeyVaultSecretsOfficer),
            KeyVaultSecretsUserValue => nameof(KeyVaultSecretsUser),
            ManagedHsmContributorValue => nameof(ManagedHsmContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two KeyVaultBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first KeyVaultBuiltInRole to compare.</param>
    /// <param name="right">The second KeyVaultBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(KeyVaultBuiltInRole left, KeyVaultBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two KeyVaultBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first KeyVaultBuiltInRole to compare.</param>
    /// <param name="right">The second KeyVaultBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(KeyVaultBuiltInRole left, KeyVaultBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a KeyVaultBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator KeyVaultBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is KeyVaultBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(KeyVaultBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
