// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// Properties to configure retention settings for the  eventhub.
/// </summary>
public partial class RetentionDescription : ProvisionableConstruct
{
    /// <summary>
    /// Enumerates the possible values for cleanup policy.
    /// </summary>
    public BicepValue<CleanupPolicyRetentionDescription> CleanupPolicy 
    {
        get { Initialize(); return _cleanupPolicy!; }
        set { Initialize(); _cleanupPolicy!.Assign(value); }
    }
    private BicepValue<CleanupPolicyRetentionDescription>? _cleanupPolicy;

    /// <summary>
    /// Number of hours to retain the events for this Event Hub. This value is
    /// only used when cleanupPolicy is Delete. If cleanupPolicy is Compact
    /// the returned value of this property is Long.MaxValue.
    /// </summary>
    public BicepValue<long> RetentionTimeInHours 
    {
        get { Initialize(); return _retentionTimeInHours!; }
        set { Initialize(); _retentionTimeInHours!.Assign(value); }
    }
    private BicepValue<long>? _retentionTimeInHours;

    /// <summary>
    /// Number of hours to retain the tombstone markers of a compacted Event
    /// Hub. This value is only used when cleanupPolicy is Compact. Consumer
    /// must complete reading the tombstone marker within this specified
    /// amount of time if consumer begins from starting offset to ensure they
    /// get a valid snapshot for the specific key described by the tombstone
    /// marker within the compacted Event Hub.
    /// </summary>
    public BicepValue<int> TombstoneRetentionTimeInHours 
    {
        get { Initialize(); return _tombstoneRetentionTimeInHours!; }
        set { Initialize(); _tombstoneRetentionTimeInHours!.Assign(value); }
    }
    private BicepValue<int>? _tombstoneRetentionTimeInHours;

    /// <summary>
    /// Creates a new RetentionDescription.
    /// </summary>
    public RetentionDescription()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RetentionDescription.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _cleanupPolicy = DefineProperty<CleanupPolicyRetentionDescription>("CleanupPolicy", ["cleanupPolicy"]);
        _retentionTimeInHours = DefineProperty<long>("RetentionTimeInHours", ["retentionTimeInHours"]);
        _tombstoneRetentionTimeInHours = DefineProperty<int>("TombstoneRetentionTimeInHours", ["tombstoneRetentionTimeInHours"]);
    }
}
