// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// Properties of the throttling policy.
/// </summary>
public partial class EventHubsThrottlingPolicy : EventHubsApplicationGroupPolicy
{
    /// <summary>
    /// The Threshold limit above which the application group will be
    /// throttled.Rate limit is always per second.
    /// </summary>
    public BicepValue<long> RateLimitThreshold 
    {
        get { Initialize(); return _rateLimitThreshold!; }
        set { Initialize(); _rateLimitThreshold!.Assign(value); }
    }
    private BicepValue<long>? _rateLimitThreshold;

    /// <summary>
    /// Metric Id on which the throttle limit should be set, MetricId can be
    /// discovered by hovering over Metric in the Metrics section of Event Hub
    /// Namespace inside Azure Portal.
    /// </summary>
    public BicepValue<EventHubsMetricId> MetricId 
    {
        get { Initialize(); return _metricId!; }
        set { Initialize(); _metricId!.Assign(value); }
    }
    private BicepValue<EventHubsMetricId>? _metricId;

    /// <summary>
    /// Creates a new EventHubsThrottlingPolicy.
    /// </summary>
    public EventHubsThrottlingPolicy() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsThrottlingPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("type", ["type"], defaultValue: "ThrottlingPolicy");
        _rateLimitThreshold = DefineProperty<long>("RateLimitThreshold", ["rateLimitThreshold"]);
        _metricId = DefineProperty<EventHubsMetricId>("MetricId", ["metricId"]);
    }
}
