// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// SKU parameters supplied to the create namespace operation.
/// </summary>
public partial class EventHubsSku : ProvisionableConstruct
{
    /// <summary>
    /// Name of this SKU.
    /// </summary>
    public BicepValue<EventHubsSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<EventHubsSkuName>? _name;

    /// <summary>
    /// The billing tier of this particular SKU.
    /// </summary>
    public BicepValue<EventHubsSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<EventHubsSkuTier>? _tier;

    /// <summary>
    /// The Event Hubs throughput units for Basic or Standard tiers, where
    /// value should be 0 to 20 throughput units. The Event Hubs premium units
    /// for Premium tier, where value should be 0 to 10 premium units.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new EventHubsSku.
    /// </summary>
    public EventHubsSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<EventHubsSkuName>("Name", ["name"]);
        _tier = DefineProperty<EventHubsSkuTier>("Tier", ["tier"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
