// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// The response from the List namespace operation.
/// </summary>
public partial class EventHubsNetworkRuleSetIPRules : ProvisionableConstruct
{
    /// <summary>
    /// IP Mask.
    /// </summary>
    public BicepValue<string> IPMask 
    {
        get { Initialize(); return _iPMask!; }
        set { Initialize(); _iPMask!.Assign(value); }
    }
    private BicepValue<string>? _iPMask;

    /// <summary>
    /// The IP Filter Action.
    /// </summary>
    public BicepValue<EventHubsNetworkRuleIPAction> Action 
    {
        get { Initialize(); return _action!; }
        set { Initialize(); _action!.Assign(value); }
    }
    private BicepValue<EventHubsNetworkRuleIPAction>? _action;

    /// <summary>
    /// Creates a new EventHubsNetworkRuleSetIPRules.
    /// </summary>
    public EventHubsNetworkRuleSetIPRules()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// EventHubsNetworkRuleSetIPRules.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _iPMask = DefineProperty<string>("IPMask", ["ipMask"]);
        _action = DefineProperty<EventHubsNetworkRuleIPAction>("Action", ["action"]);
    }
}
