// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// SKU parameters particular to a cluster instance.
/// </summary>
public partial class EventHubsClusterSku : ProvisionableConstruct
{
    /// <summary>
    /// Name of this SKU.
    /// </summary>
    public BicepValue<EventHubsClusterSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<EventHubsClusterSkuName>? _name;

    /// <summary>
    /// The quantity of Event Hubs Cluster Capacity Units contained in this
    /// cluster.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new EventHubsClusterSku.
    /// </summary>
    public EventHubsClusterSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsClusterSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<EventHubsClusterSkuName>("Name", ["name"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
