// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// A value that indicates whether capture description is enabled.
/// </summary>
public partial class EventHubsCaptureIdentity : ProvisionableConstruct
{
    /// <summary>
    /// Type of Azure Active Directory Managed Identity.
    /// </summary>
    public BicepValue<EventHubsCaptureIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<EventHubsCaptureIdentityType>? _identityType;

    /// <summary>
    /// ARM ID of Managed User Identity. This property is required is the type
    /// is UserAssignedIdentity. If type is SystemAssigned, then the System
    /// Assigned Identity Associated with the namespace will be used.
    /// </summary>
    public BicepValue<string> UserAssignedIdentity 
    {
        get { Initialize(); return _userAssignedIdentity!; }
        set { Initialize(); _userAssignedIdentity!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentity;

    /// <summary>
    /// Creates a new EventHubsCaptureIdentity.
    /// </summary>
    public EventHubsCaptureIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsCaptureIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<EventHubsCaptureIdentityType>("IdentityType", ["type"]);
        _userAssignedIdentity = DefineProperty<string>("UserAssignedIdentity", ["userAssignedIdentity"]);
    }
}
