// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// Properties of the Application Group policy             Please note
/// Azure.ResourceManager.EventHubs.Models.EventHubsApplicationGroupPolicy is
/// the base class. According to the scenario, a derived class of the base
/// class might need to be assigned here, or this property needs to be casted
/// to one of the possible derived classes.             The available derived
/// classes include
/// Azure.ResourceManager.EventHubs.Models.EventHubsThrottlingPolicy.
/// </summary>
public partial class EventHubsApplicationGroupPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The Name of this policy.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new EventHubsApplicationGroupPolicy.
    /// </summary>
    public EventHubsApplicationGroupPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// EventHubsApplicationGroupPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
    }
}
