// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// Capture storage details for capture description.
/// </summary>
public partial class EventHubDestination : ProvisionableConstruct
{
    /// <summary>
    /// Name for capture destination.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// A value that indicates whether capture description is enabled.
    /// </summary>
    public EventHubsCaptureIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private EventHubsCaptureIdentity? _identity;

    /// <summary>
    /// Resource id of the storage account to be used to create the blobs.
    /// </summary>
    public BicepValue<ResourceIdentifier> StorageAccountResourceId 
    {
        get { Initialize(); return _storageAccountResourceId!; }
        set { Initialize(); _storageAccountResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _storageAccountResourceId;

    /// <summary>
    /// Blob container Name.
    /// </summary>
    public BicepValue<string> BlobContainer 
    {
        get { Initialize(); return _blobContainer!; }
        set { Initialize(); _blobContainer!.Assign(value); }
    }
    private BicepValue<string>? _blobContainer;

    /// <summary>
    /// Blob naming convention for archive, e.g.
    /// {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}.
    /// Here all the parameters (Namespace,EventHub .. etc) are mandatory
    /// irrespective of order.
    /// </summary>
    public BicepValue<string> ArchiveNameFormat 
    {
        get { Initialize(); return _archiveNameFormat!; }
        set { Initialize(); _archiveNameFormat!.Assign(value); }
    }
    private BicepValue<string>? _archiveNameFormat;

    /// <summary>
    /// Subscription Id of Azure Data Lake Store.
    /// </summary>
    public BicepValue<Guid> DataLakeSubscriptionId 
    {
        get { Initialize(); return _dataLakeSubscriptionId!; }
        set { Initialize(); _dataLakeSubscriptionId!.Assign(value); }
    }
    private BicepValue<Guid>? _dataLakeSubscriptionId;

    /// <summary>
    /// The Azure Data Lake Store name for the captured events.
    /// </summary>
    public BicepValue<string> DataLakeAccountName 
    {
        get { Initialize(); return _dataLakeAccountName!; }
        set { Initialize(); _dataLakeAccountName!.Assign(value); }
    }
    private BicepValue<string>? _dataLakeAccountName;

    /// <summary>
    /// The destination folder path for the captured events.
    /// </summary>
    public BicepValue<string> DataLakeFolderPath 
    {
        get { Initialize(); return _dataLakeFolderPath!; }
        set { Initialize(); _dataLakeFolderPath!.Assign(value); }
    }
    private BicepValue<string>? _dataLakeFolderPath;

    /// <summary>
    /// Creates a new EventHubDestination.
    /// </summary>
    public EventHubDestination()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubDestination.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _identity = DefineModelProperty<EventHubsCaptureIdentity>("Identity", ["identity"]);
        _storageAccountResourceId = DefineProperty<ResourceIdentifier>("StorageAccountResourceId", ["properties", "storageAccountResourceId"]);
        _blobContainer = DefineProperty<string>("BlobContainer", ["properties", "blobContainer"]);
        _archiveNameFormat = DefineProperty<string>("ArchiveNameFormat", ["properties", "archiveNameFormat"]);
        _dataLakeSubscriptionId = DefineProperty<Guid>("DataLakeSubscriptionId", ["properties", "dataLakeSubscriptionId"]);
        _dataLakeAccountName = DefineProperty<string>("DataLakeAccountName", ["properties", "dataLakeAccountName"]);
        _dataLakeFolderPath = DefineProperty<string>("DataLakeFolderPath", ["properties", "dataLakeFolderPath"]);
    }
}
