// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// Properties to configure capture description for eventhub.
/// </summary>
public partial class CaptureDescription : ProvisionableConstruct
{
    /// <summary>
    /// A value that indicates whether capture description is enabled.
    /// </summary>
    public BicepValue<bool> Enabled 
    {
        get { Initialize(); return _enabled!; }
        set { Initialize(); _enabled!.Assign(value); }
    }
    private BicepValue<bool>? _enabled;

    /// <summary>
    /// Enumerates the possible values for the encoding format of capture
    /// description. Note: &apos;AvroDeflate&apos; will be deprecated in New
    /// API Version.
    /// </summary>
    public BicepValue<EncodingCaptureDescription> Encoding 
    {
        get { Initialize(); return _encoding!; }
        set { Initialize(); _encoding!.Assign(value); }
    }
    private BicepValue<EncodingCaptureDescription>? _encoding;

    /// <summary>
    /// The time window allows you to set the frequency with which the capture
    /// to Azure Blobs will happen, value should between 60 to 900 seconds.
    /// </summary>
    public BicepValue<int> IntervalInSeconds 
    {
        get { Initialize(); return _intervalInSeconds!; }
        set { Initialize(); _intervalInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _intervalInSeconds;

    /// <summary>
    /// The size window defines the amount of data built up in your Event Hub
    /// before an capture operation, value should be between 10485760 to
    /// 524288000 bytes.
    /// </summary>
    public BicepValue<int> SizeLimitInBytes 
    {
        get { Initialize(); return _sizeLimitInBytes!; }
        set { Initialize(); _sizeLimitInBytes!.Assign(value); }
    }
    private BicepValue<int>? _sizeLimitInBytes;

    /// <summary>
    /// Properties of Destination where capture will be stored. (Storage
    /// Account, Blob Names).
    /// </summary>
    public EventHubDestination Destination 
    {
        get { Initialize(); return _destination!; }
        set { Initialize(); AssignOrReplace(ref _destination, value); }
    }
    private EventHubDestination? _destination;

    /// <summary>
    /// A value that indicates whether to Skip Empty Archives.
    /// </summary>
    public BicepValue<bool> SkipEmptyArchives 
    {
        get { Initialize(); return _skipEmptyArchives!; }
        set { Initialize(); _skipEmptyArchives!.Assign(value); }
    }
    private BicepValue<bool>? _skipEmptyArchives;

    /// <summary>
    /// Creates a new CaptureDescription.
    /// </summary>
    public CaptureDescription()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CaptureDescription.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _enabled = DefineProperty<bool>("Enabled", ["enabled"]);
        _encoding = DefineProperty<EncodingCaptureDescription>("Encoding", ["encoding"]);
        _intervalInSeconds = DefineProperty<int>("IntervalInSeconds", ["intervalInSeconds"]);
        _sizeLimitInBytes = DefineProperty<int>("SizeLimitInBytes", ["sizeLimitInBytes"]);
        _destination = DefineModelProperty<EventHubDestination>("Destination", ["destination"]);
        _skipEmptyArchives = DefineProperty<bool>("SkipEmptyArchives", ["skipEmptyArchives"]);
    }
}
