// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// EventHubsSchemaGroup.
/// </summary>
public partial class EventHubsSchemaGroup : ProvisionableResource
{
    /// <summary>
    /// The Schema Group name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// dictionary object for SchemaGroup group properties.
    /// </summary>
    public BicepDictionary<string> GroupProperties 
    {
        get { Initialize(); return _groupProperties!; }
        set { Initialize(); _groupProperties!.Assign(value); }
    }
    private BicepDictionary<string>? _groupProperties;

    /// <summary>
    /// Gets or sets the schema compatibility.
    /// </summary>
    public BicepValue<EventHubsSchemaCompatibility> SchemaCompatibility 
    {
        get { Initialize(); return _schemaCompatibility!; }
        set { Initialize(); _schemaCompatibility!.Assign(value); }
    }
    private BicepValue<EventHubsSchemaCompatibility>? _schemaCompatibility;

    /// <summary>
    /// Gets or sets the schema type.
    /// </summary>
    public BicepValue<EventHubsSchemaType> SchemaType 
    {
        get { Initialize(); return _schemaType!; }
        set { Initialize(); _schemaType!.Assign(value); }
    }
    private BicepValue<EventHubsSchemaType>? _schemaType;

    /// <summary>
    /// Exact time the Schema Group was created.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedAtUtc 
    {
        get { Initialize(); return _createdAtUtc!; }
    }
    private BicepValue<DateTimeOffset>? _createdAtUtc;

    /// <summary>
    /// The ETag value.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The geo-location where the resource lives.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Exact time the Schema Group was updated.
    /// </summary>
    public BicepValue<DateTimeOffset> UpdatedAtUtc 
    {
        get { Initialize(); return _updatedAtUtc!; }
    }
    private BicepValue<DateTimeOffset>? _updatedAtUtc;

    /// <summary>
    /// Gets or sets a reference to the parent EventHubsNamespace.
    /// </summary>
    public EventHubsNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EventHubsNamespace>? _parent;

    /// <summary>
    /// Creates a new EventHubsSchemaGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsSchemaGroup resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsSchemaGroup.</param>
    public EventHubsSchemaGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventHub/namespaces/schemagroups", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsSchemaGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _groupProperties = DefineDictionaryProperty<string>("GroupProperties", ["properties", "groupProperties"]);
        _schemaCompatibility = DefineProperty<EventHubsSchemaCompatibility>("SchemaCompatibility", ["properties", "schemaCompatibility"]);
        _schemaType = DefineProperty<EventHubsSchemaType>("SchemaType", ["properties", "schemaType"]);
        _createdAtUtc = DefineProperty<DateTimeOffset>("CreatedAtUtc", ["properties", "createdAtUtc"], isOutput: true);
        _eTag = DefineProperty<ETag>("ETag", ["properties", "eTag"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _updatedAtUtc = DefineProperty<DateTimeOffset>("UpdatedAtUtc", ["properties", "updatedAtUtc"], isOutput: true);
        _parent = DefineResource<EventHubsNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported EventHubsSchemaGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2014-09-01.
        /// </summary>
        public static readonly string V2014_09_01 = "2014-09-01";
    }

    /// <summary>
    /// Creates a reference to an existing EventHubsSchemaGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsSchemaGroup resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsSchemaGroup.</param>
    /// <returns>The existing EventHubsSchemaGroup resource.</returns>
    public static EventHubsSchemaGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
