// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// EventHubsNetworkRuleSet.
/// </summary>
public partial class EventHubsNetworkRuleSet : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Default Action for Network Rule Set.
    /// </summary>
    public BicepValue<EventHubsNetworkRuleSetDefaultAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<EventHubsNetworkRuleSetDefaultAction>? _defaultAction;

    /// <summary>
    /// List of IpRules.
    /// </summary>
    public BicepList<EventHubsNetworkRuleSetIPRules> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<EventHubsNetworkRuleSetIPRules>? _iPRules;

    /// <summary>
    /// This determines if traffic is allowed over public network. By default
    /// it is enabled. If value is SecuredByPerimeter then Inbound and
    /// Outbound communication is controlled by the network security perimeter
    /// and profile&apos;s access rules.
    /// </summary>
    public BicepValue<EventHubsPublicNetworkAccessFlag> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<EventHubsPublicNetworkAccessFlag>? _publicNetworkAccess;

    /// <summary>
    /// Value that indicates whether Trusted Service Access is Enabled or not.
    /// </summary>
    public BicepValue<bool> TrustedServiceAccessEnabled 
    {
        get { Initialize(); return _trustedServiceAccessEnabled!; }
        set { Initialize(); _trustedServiceAccessEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _trustedServiceAccessEnabled;

    /// <summary>
    /// List VirtualNetwork Rules.
    /// </summary>
    public BicepList<EventHubsNetworkRuleSetVirtualNetworkRules> VirtualNetworkRules 
    {
        get { Initialize(); return _virtualNetworkRules!; }
        set { Initialize(); _virtualNetworkRules!.Assign(value); }
    }
    private BicepList<EventHubsNetworkRuleSetVirtualNetworkRules>? _virtualNetworkRules;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The geo-location where the resource lives.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent EventHubsNamespace.
    /// </summary>
    public EventHubsNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<EventHubsNamespace>? _parent;

    /// <summary>
    /// Creates a new EventHubsNetworkRuleSet.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsNetworkRuleSet resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsNetworkRuleSet.</param>
    public EventHubsNetworkRuleSet(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventHub/namespaces/networkRuleSets", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _defaultAction = DefineProperty<EventHubsNetworkRuleSetDefaultAction>("DefaultAction", ["properties", "defaultAction"]);
        _iPRules = DefineListProperty<EventHubsNetworkRuleSetIPRules>("IPRules", ["properties", "ipRules"]);
        _publicNetworkAccess = DefineProperty<EventHubsPublicNetworkAccessFlag>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _trustedServiceAccessEnabled = DefineProperty<bool>("TrustedServiceAccessEnabled", ["properties", "trustedServiceAccessEnabled"]);
        _virtualNetworkRules = DefineListProperty<EventHubsNetworkRuleSetVirtualNetworkRules>("VirtualNetworkRules", ["properties", "virtualNetworkRules"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<EventHubsNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported EventHubsNetworkRuleSet resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing EventHubsNetworkRuleSet.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsNetworkRuleSet resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsNetworkRuleSet.</param>
    /// <returns>The existing EventHubsNetworkRuleSet resource.</returns>
    public static EventHubsNetworkRuleSet FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
