// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.EventHubs;

/// <summary>
/// EventHubsNamespace.
/// </summary>
public partial class EventHubsNamespace : ProvisionableResource
{
    /// <summary>
    /// The Namespace name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Alternate name specified when alias and namespace names are same.
    /// </summary>
    public BicepValue<string> AlternateName 
    {
        get { Initialize(); return _alternateName!; }
        set { Initialize(); _alternateName!.Assign(value); }
    }
    private BicepValue<string>? _alternateName;

    /// <summary>
    /// Cluster ARM ID of the Namespace.
    /// </summary>
    public BicepValue<ResourceIdentifier> ClusterArmId 
    {
        get { Initialize(); return _clusterArmId!; }
        set { Initialize(); _clusterArmId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _clusterArmId;

    /// <summary>
    /// This property disables SAS authentication for the Event Hubs namespace.
    /// </summary>
    public BicepValue<bool> DisableLocalAuth 
    {
        get { Initialize(); return _disableLocalAuth!; }
        set { Initialize(); _disableLocalAuth!.Assign(value); }
    }
    private BicepValue<bool>? _disableLocalAuth;

    /// <summary>
    /// Properties of BYOK Encryption description.
    /// </summary>
    public EventHubsEncryption Encryption 
    {
        get { Initialize(); return _encryption!; }
        set { Initialize(); AssignOrReplace(ref _encryption, value); }
    }
    private EventHubsEncryption? _encryption;

    /// <summary>
    /// Geo Data Replication settings for the namespace.
    /// </summary>
    public NamespaceGeoDataReplicationProperties GeoDataReplication 
    {
        get { Initialize(); return _geoDataReplication!; }
        set { Initialize(); AssignOrReplace(ref _geoDataReplication, value); }
    }
    private NamespaceGeoDataReplicationProperties? _geoDataReplication;

    /// <summary>
    /// Properties of BYOK Identity description.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Value that indicates whether AutoInflate is enabled for eventhub
    /// namespace.
    /// </summary>
    public BicepValue<bool> IsAutoInflateEnabled 
    {
        get { Initialize(); return _isAutoInflateEnabled!; }
        set { Initialize(); _isAutoInflateEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAutoInflateEnabled;

    /// <summary>
    /// Value that indicates whether Kafka is enabled for eventhub namespace.
    /// </summary>
    public BicepValue<bool> KafkaEnabled 
    {
        get { Initialize(); return _kafkaEnabled!; }
        set { Initialize(); _kafkaEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _kafkaEnabled;

    /// <summary>
    /// Upper limit of throughput units when AutoInflate is enabled, value
    /// should be within 0 to 20 throughput units. ( &apos;0&apos; if
    /// AutoInflateEnabled = true).
    /// </summary>
    public BicepValue<int> MaximumThroughputUnits 
    {
        get { Initialize(); return _maximumThroughputUnits!; }
        set { Initialize(); _maximumThroughputUnits!.Assign(value); }
    }
    private BicepValue<int>? _maximumThroughputUnits;

    /// <summary>
    /// The minimum TLS version for the cluster to support, e.g.
    /// &apos;1.2&apos;.
    /// </summary>
    public BicepValue<EventHubsTlsVersion> MinimumTlsVersion 
    {
        get { Initialize(); return _minimumTlsVersion!; }
        set { Initialize(); _minimumTlsVersion!.Assign(value); }
    }
    private BicepValue<EventHubsTlsVersion>? _minimumTlsVersion;

    /// <summary>
    /// List of private endpoint connections.
    /// </summary>
    public BicepList<EventHubsPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
        set { Initialize(); _privateEndpointConnections!.Assign(value); }
    }
    private BicepList<EventHubsPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// This determines if traffic is allowed over public network. By default
    /// it is enabled.
    /// </summary>
    public BicepValue<EventHubsPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<EventHubsPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// Properties of sku resource.
    /// </summary>
    public EventHubsSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private EventHubsSku? _sku;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Enabling this property creates a Standard Event Hubs Namespace in
    /// regions supported availability zones.
    /// </summary>
    public BicepValue<bool> ZoneRedundant 
    {
        get { Initialize(); return _zoneRedundant!; }
        set { Initialize(); _zoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _zoneRedundant;

    /// <summary>
    /// The time the Namespace was created.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Identifier for Azure Insights metrics.
    /// </summary>
    public BicepValue<string> MetricId 
    {
        get { Initialize(); return _metricId!; }
    }
    private BicepValue<string>? _metricId;

    /// <summary>
    /// Provisioning state of the Namespace.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Endpoint you can use to perform Service Bus operations.
    /// </summary>
    public BicepValue<string> ServiceBusEndpoint 
    {
        get { Initialize(); return _serviceBusEndpoint!; }
    }
    private BicepValue<string>? _serviceBusEndpoint;

    /// <summary>
    /// Status of the Namespace.
    /// </summary>
    public BicepValue<string> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<string>? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The time the Namespace was updated.
    /// </summary>
    public BicepValue<DateTimeOffset> UpdatedOn 
    {
        get { Initialize(); return _updatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _updatedOn;

    /// <summary>
    /// Creates a new EventHubsNamespace.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsNamespace resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsNamespace.</param>
    public EventHubsNamespace(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.EventHub/namespaces", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of EventHubsNamespace.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _alternateName = DefineProperty<string>("AlternateName", ["properties", "alternateName"]);
        _clusterArmId = DefineProperty<ResourceIdentifier>("ClusterArmId", ["properties", "clusterArmId"]);
        _disableLocalAuth = DefineProperty<bool>("DisableLocalAuth", ["properties", "disableLocalAuth"]);
        _encryption = DefineModelProperty<EventHubsEncryption>("Encryption", ["properties", "encryption"]);
        _geoDataReplication = DefineModelProperty<NamespaceGeoDataReplicationProperties>("GeoDataReplication", ["properties", "geoDataReplication"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _isAutoInflateEnabled = DefineProperty<bool>("IsAutoInflateEnabled", ["properties", "isAutoInflateEnabled"]);
        _kafkaEnabled = DefineProperty<bool>("KafkaEnabled", ["properties", "kafkaEnabled"]);
        _maximumThroughputUnits = DefineProperty<int>("MaximumThroughputUnits", ["properties", "maximumThroughputUnits"]);
        _minimumTlsVersion = DefineProperty<EventHubsTlsVersion>("MinimumTlsVersion", ["properties", "minimumTlsVersion"]);
        _privateEndpointConnections = DefineListProperty<EventHubsPrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"]);
        _publicNetworkAccess = DefineProperty<EventHubsPublicNetworkAccess>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _sku = DefineModelProperty<EventHubsSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _zoneRedundant = DefineProperty<bool>("ZoneRedundant", ["properties", "zoneRedundant"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "createdAt"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _metricId = DefineProperty<string>("MetricId", ["properties", "metricId"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _serviceBusEndpoint = DefineProperty<string>("ServiceBusEndpoint", ["properties", "serviceBusEndpoint"], isOutput: true);
        _status = DefineProperty<string>("Status", ["properties", "status"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _updatedOn = DefineProperty<DateTimeOffset>("UpdatedOn", ["properties", "updatedAt"], isOutput: true);
    }

    /// <summary>
    /// Supported EventHubsNamespace resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2014-09-01.
        /// </summary>
        public static readonly string V2014_09_01 = "2014-09-01";
    }

    /// <summary>
    /// Creates a reference to an existing EventHubsNamespace.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the EventHubsNamespace resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the EventHubsNamespace.</param>
    /// <returns>The existing EventHubsNamespace resource.</returns>
    public static EventHubsNamespace FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this EventHubsNamespace resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 256, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period);

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this EventHubsNamespace.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(EventHubsBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{EventHubsBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// EventHubsNamespace.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(EventHubsBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{EventHubsBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
